/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.UUID;
import java.util.regex.Pattern;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class CacheParser
extends KeywordParserFactory {
    private static final Pattern P_INT = Pattern.compile("\\-?[0-9\\*\\/\\+\\-]+");

    public static void validateDurationStr(String d, IContext ctx) {
        if ("null".equals(d)) {
            return;
        }
        if (d.startsWith("\"") && d.endsWith("\"")) {
            String s = S.stripQuotation(d);
            try {
                ctx.getEngine().conf().durationParser().parseDuration(s);
            }
            catch (Exception e) {
                CacheParser.raiseParseException(ctx, "Invalid time duration: %s", d);
            }
        } else if (!P_INT.matcher(d).matches()) {
            CacheParser.raiseParseException(ctx, "Invalid time duration: %s. int(second) or string expected. String must be double quoted", d);
        }
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String blank;
                Regex r0;
                String matched;
                Regex r = CacheParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @cache statement. Correct usage: @cache (\"duration_string\") {cache block}", new Object[0]);
                }
                if ((matched = r.stringMatched()).startsWith("\n") || matched.endsWith("\n")) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                ctx.step(r.stringMatched().length());
                String s = r.stringMatched(2);
                s = S.stripBrace(s);
                String[] sa = s.split(",");
                String duration = null;
                if (sa.length > 0) {
                    duration = sa[0];
                }
                String args = "";
                if (sa.length > 1) {
                    StringBuilder sb = new StringBuilder("");
                    for (int i = 1; i < sa.length; ++i) {
                        sb.append(",").append(sa[i]);
                    }
                    args = sb.toString();
                }
                return new CacheToken(duration, args, this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.CACHE;
    }

    @Override
    protected String patternStr() {
        return "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))(\\s*\\{)?\\n?)";
    }

    private static class CacheToken
    extends BlockCodeToken {
        private String args;
        private String duration;
        private int startIndex;
        private int endIndex;
        private String key;

        CacheToken(String duration, String args, IContext ctx) {
            super("", ctx);
            this.duration = S.isEmpty(duration) ? "null" : duration;
            CacheParser.validateDurationStr(this.duration, ctx);
            this.args = args;
            this.startIndex = ctx.cursor();
        }

        @Override
        public void output() {
            this.p("{");
            this.pline();
            this.pt("java.io.Serializable s = __engine().cached(\"").p(this.key).p("\"").p(this.args).p(");");
            this.pline();
            this.pt("if (null != s) {");
            this.pline();
            this.p2t("p(s);");
            this.pline();
            this.pt("} else {");
            this.pline();
            this.p2t("StringBuilder sbOld = __getBuffer();");
            this.pline();
            this.p2t("StringBuilder sbNew = new StringBuilder();");
            this.pline();
            this.p2t("__setBuffer(sbNew);");
            this.pline();
        }

        @Override
        public String closeBlock() {
            this.endIndex = this.ctx.cursor();
            String body = this.ctx.getTemplateSource(this.startIndex, this.endIndex);
            String tmplName = this.ctx.getTemplateClass().name();
            String keySeed = body + tmplName;
            this.key = UUID.nameUUIDFromBytes(keySeed.getBytes()).toString();
            StringBuilder sbOld = this.__getBuffer();
            StringBuilder sbNew = new StringBuilder();
            this.__setBuffer(sbNew);
            this.p2t("s = sbNew.toString();");
            this.pline();
            this.p2t("__setBuffer(sbOld);");
            this.pline();
            this.p2t("__engine().cache(\"").p(this.key).p("\",s,").p(this.duration).p(this.args).p(");");
            this.pline();
            this.p2t("p(s);");
            this.pline();
            this.pt("}");
            this.pline();
            this.p("}");
            this.pline();
            String s = sbNew.toString();
            this.__setBuffer(sbOld);
            return s;
        }
    }
}

