/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.extension;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rythmengine.utils.Escape;

public interface ICodeType {
    public String commentStart();

    public String commentEnd();

    public Escape escape();

    public String blockStart();

    public String blockEnd();

    public boolean allowInternalTypeBlock();

    public Set<ICodeType> allowedExternalTypes();

    public void setParent(ICodeType var1);

    public ICodeType getParent();

    public String newInstanceStr();

    public String resourceNameSuffix();

    public static class DefImpl
    implements ICodeType,
    Cloneable {
        public static final DefImpl RAW = new DefImpl("RAW", null, null, Escape.RAW, "");
        public static final DefImpl HTML = new DefImpl("HTML", "<!--", "-->", Escape.XML, ".html"){

            @Override
            public boolean allowInternalTypeBlock() {
                return true;
            }

            @Override
            public String toString() {
                return "HTML";
            }
        };
        public static final DefImpl XML = new DefImpl("XML", "<!--", "-->", Escape.XML, ".xml");
        public static final DefImpl JS = new DefImpl("JS", "/*", "*/", Escape.JS, "(<\\s*script[^<>]*?>).*", "(\\<\\/\\s*script\\s*\\>).*", ".js"){

            @Override
            public Set<ICodeType> allowedExternalTypes() {
                HashSet<ICodeType> set = new HashSet<ICodeType>();
                set.add(HTML);
                return set;
            }
        };
        public static final DefImpl CSS = new DefImpl("CSS", "/*", "*/", Escape.JS, "(<\\s*style[^<>]*?>).*", "(\\<\\/\\s*style\\s*\\>).*", ".css"){

            @Override
            public Set<ICodeType> allowedExternalTypes() {
                HashSet<ICodeType> set = new HashSet<ICodeType>();
                set.add(HTML);
                return set;
            }
        };
        public static final DefImpl JSON = new DefImpl("JSON", null, null, Escape.JSON, ".json");
        public static final DefImpl CSV = new DefImpl("CSV", null, null, Escape.CSV, ".csv");
        private final String id;
        private final String commentStart;
        private final String commentEnd;
        private final Escape escape;
        private final String blockStart;
        private final String blockEnd;
        private ICodeType parent;
        private final String suffix;

        protected DefImpl(String id, String commentStart, String commentEnd, Escape escape, String suffix) {
            this(id, commentStart, commentEnd, escape, null, null, suffix);
        }

        protected DefImpl(String id, String commentStart, String commentEnd, Escape escape, String blockStart, String blockEnd, String suffix) {
            this.id = id;
            this.commentEnd = commentEnd;
            this.commentStart = commentStart;
            this.escape = escape;
            this.blockEnd = blockEnd;
            this.blockStart = blockStart;
            this.suffix = suffix;
        }

        @Override
        public String newInstanceStr() {
            StringBuilder sb = new StringBuilder();
            String clsName = ICodeType.class.getName();
            sb.append("(").append(clsName).append(")").append(clsName).append(".DefImpl.").append(this.id).append(".clone()");
            return sb.toString();
        }

        @Override
        public String commentStart() {
            return this.commentStart;
        }

        @Override
        public String commentEnd() {
            return this.commentEnd;
        }

        @Override
        public Escape escape() {
            return this.escape;
        }

        @Override
        public String blockStart() {
            return this.blockStart;
        }

        @Override
        public String blockEnd() {
            return this.blockEnd;
        }

        @Override
        public boolean allowInternalTypeBlock() {
            return false;
        }

        @Override
        public void setParent(ICodeType parent) {
            this.parent = parent;
        }

        @Override
        public ICodeType getParent() {
            return this.parent;
        }

        @Override
        public Set<ICodeType> allowedExternalTypes() {
            return Collections.emptySet();
        }

        @Override
        public String resourceNameSuffix() {
            return this.suffix;
        }

        public String toString() {
            return this.newInstanceStr();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

