/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.configuration.PlexusConfiguration;

final class XmlUtil {
    private XmlUtil() {
    }

    static int estimateIndentationSize(BufferedReader xml) throws IOException {
        String line;
        boolean inComment = false;
        HashMap<Integer, Integer> indentHist = new HashMap<Integer, Integer>(2);
        int prevIndent = 0;
        int prevNonWhiteSpaceIdx = 0;
        while ((line = xml.readLine()) != null) {
            if (inComment) {
                if (!line.contains("-->")) continue;
                inComment = false;
                continue;
            }
            int startCommentIdx = line.indexOf("<!--");
            int endCommentIdx = line.indexOf("-->");
            inComment = startCommentIdx >= 0 && endCommentIdx == -1;
            int nonWhitespaceIdx = -1;
            int maxCheckIdx = startCommentIdx >= 0 ? startCommentIdx : line.length();
            for (int i = 0; i < maxCheckIdx; ++i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                nonWhitespaceIdx = i;
                break;
            }
            if (nonWhitespaceIdx == -1) continue;
            int indent = Math.abs(nonWhitespaceIdx - prevNonWhiteSpaceIdx);
            if (indent > 0) {
                indentHist.compute(indent, (x, count) -> count == null ? 1 : count + 1);
                prevIndent = indent;
            } else if (prevIndent != 0) {
                indentHist.compute(prevIndent, (x, count) -> count == null ? 1 : count + 1);
            }
            prevNonWhiteSpaceIdx = nonWhitespaceIdx;
        }
        return indentHist.isEmpty() ? 2 : (Integer)((Map.Entry)indentHist.entrySet().stream().reduce(new AbstractMap.SimpleEntry<Integer, Integer>(0, 1), (a, b) -> (Integer)a.getValue() > (Integer)b.getValue() ? a : b)).getKey();
    }

    static void toIndentedString(PlexusConfiguration xml, int indentationSize, int currentDepth, Writer wrt) throws IOException {
        XmlUtil.indent(indentationSize, currentDepth, wrt);
        boolean hasChildren = xml.getChildCount() > 0;
        boolean hasContent = xml.getValue() != null && !xml.getValue().isEmpty();
        wrt.write(60);
        wrt.write(xml.getName());
        if (!hasChildren && !hasContent) {
            wrt.write("/>");
        } else {
            wrt.write(62);
            if (hasChildren) {
                wrt.write(10);
                for (PlexusConfiguration c : xml.getChildren()) {
                    XmlUtil.toIndentedString(c, indentationSize, currentDepth + 1, wrt);
                    wrt.append('\n');
                }
                if (!hasContent) {
                    XmlUtil.indent(indentationSize, currentDepth, wrt);
                }
            }
            if (hasContent) {
                XmlUtil.escaped(wrt, xml.getValue());
            }
            wrt.write("</");
            wrt.write(xml.getName());
            wrt.write(62);
        }
    }

    private static void indent(int indentationSize, int currentDepth, Writer wrt) throws IOException {
        int numSpaces = currentDepth * indentationSize;
        for (int i = 0; i < numSpaces; ++i) {
            wrt.write(32);
        }
    }

    private static void escaped(Writer wrt, String value) throws IOException {
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    wrt.write("&amp;");
                    continue block5;
                }
                case '<': {
                    wrt.write("&lt;");
                    continue block5;
                }
                case '>': {
                    wrt.write("&gt;");
                    continue block5;
                }
                default: {
                    wrt.write(c);
                }
            }
        }
    }
}

