/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import org.revapi.maven.AbstractSuggestionsBuilder;

public class JsonSuggestionsBuilder
extends AbstractSuggestionsBuilder {
    @Override
    protected void appendDifferenceField(StringBuilder sb, String key, String value) {
        sb.append("  \"").append(JsonSuggestionsBuilder.escape(key)).append("\": \"").append(JsonSuggestionsBuilder.escape(value)).append("\"");
    }

    @Override
    protected void appendDifferenceFieldSeparator(StringBuilder sb) {
        sb.append(",\n");
    }

    @Override
    protected void prologue(StringBuilder sb) {
    }

    @Override
    protected void startDifference(StringBuilder sb) {
        sb.append("{\n");
    }

    @Override
    protected void endDifference(StringBuilder sb) {
        sb.append("\n},\n");
    }

    @Override
    protected void startOptionalAttachmentsInComment(StringBuilder sb, String text) {
        sb.append("\n  /*");
    }

    @Override
    protected void endOptionalAttachmentsInComment(StringBuilder sb) {
        sb.append("  */\n");
    }

    @Override
    protected void epilogue(StringBuilder sb) {
    }

    private static String escape(Object obj) {
        if (obj == null) {
            return "null";
        }
        String string = obj.toString();
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        block9: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

