/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Reporter;

public final class BuildTimeReporter
implements Reporter {
    public static final String BREAKING_SEVERITY_KEY = "org.revapi.maven.buildTimeBreakingSeverity";
    public static final String OUTPUT_NON_IDENTIFYING_ATTACHMENTS = "org.revapi.maven.outputNonIdentifyingAttachments";
    public static final String SUGGESTIONS_BUILDER_KEY = "org.revapi.maven.buildTimeSuggestionsBuilder";
    private DifferenceSeverity breakingSeverity;
    private List<Report> allProblems;
    private List<Archive> oldApi;
    private List<Archive> newApi;
    private boolean outputNonIdentifyingAttachments;
    private SuggestionsBuilder suggestionsBuilder;

    public boolean hasBreakingProblems() {
        return this.allProblems != null && !this.allProblems.isEmpty();
    }

    public String getAllProblemsMessage() {
        StringBuilder errors = new StringBuilder("The following API problems caused the build to fail:\n");
        for (Report r : this.allProblems) {
            Archive archive;
            Element element = r.getNewElement();
            if (element == null) {
                element = r.getOldElement();
                assert (element != null);
                archive = this.shouldOutputArchive(this.oldApi, element.getArchive()) ? element.getArchive() : null;
            } else {
                archive = this.shouldOutputArchive(this.newApi, element.getArchive()) ? element.getArchive() : null;
            }
            for (Difference d : r.getDifferences()) {
                if (!this.isReportable(d)) continue;
                errors.append(d.code).append(": ").append(element.getFullHumanReadableString()).append(": ").append(d.description);
                if (archive != null) {
                    errors.append(" [").append(archive.getName()).append("]");
                }
                errors.append("\n");
            }
        }
        return errors.toString();
    }

    public String getIgnoreSuggestion() {
        if (this.allProblems.isEmpty()) {
            return null;
        }
        return this.suggestionsBuilder.build(this.allProblems, new SuggestionBuilderContext());
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.maven.internal.buildTimeReporter";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext context) {
        this.allProblems = new ArrayList<Report>();
        this.oldApi = new ArrayList<Archive>();
        for (Archive a : context.getOldApi().getArchives()) {
            this.oldApi.add(a);
        }
        this.newApi = new ArrayList<Archive>();
        for (Archive a : context.getNewApi().getArchives()) {
            this.newApi.add(a);
        }
        this.breakingSeverity = (DifferenceSeverity)context.getData(BREAKING_SEVERITY_KEY);
        if (this.breakingSeverity == null) {
            throw new IllegalStateException("Breaking severity must be provided in the context data of the BuildTimeReporter. If you see this, you've come across a bug, please report it.");
        }
        Boolean outputNonIdentifyingAttachments = (Boolean)context.getData(OUTPUT_NON_IDENTIFYING_ATTACHMENTS);
        this.outputNonIdentifyingAttachments = outputNonIdentifyingAttachments == null ? true : outputNonIdentifyingAttachments;
        this.suggestionsBuilder = (SuggestionsBuilder)context.getData(SUGGESTIONS_BUILDER_KEY);
        if (this.suggestionsBuilder == null) {
            throw new IllegalStateException("SuggestionBuilder instance must be provided in the context data of the BuildTimeReporter. If you see this, you've come across a bug, please report it.");
        }
    }

    public void report(@Nonnull Report report) {
        Element element = report.getNewElement();
        if (element == null) {
            element = report.getOldElement();
        }
        if (element == null) {
            return;
        }
        for (Difference d : report.getDifferences()) {
            if (!this.isReportable(d)) continue;
            this.allProblems.add(report);
            break;
        }
    }

    private boolean isReportable(Difference d) {
        DifferenceSeverity maxSeverity = DifferenceSeverity.NON_BREAKING;
        for (DifferenceSeverity s : d.classification.values()) {
            if (maxSeverity.compareTo((Enum)s) >= 0) continue;
            maxSeverity = s;
        }
        return maxSeverity.compareTo((Enum)this.breakingSeverity) >= 0;
    }

    private boolean shouldOutputArchive(List<Archive> primaryApi, Archive archive) {
        return !primaryApi.contains(archive) || primaryApi.size() > 1;
    }

    public void close() throws IOException {
    }

    public final class SuggestionBuilderContext {
        boolean isReportable(Difference difference) {
            return BuildTimeReporter.this.isReportable(difference);
        }

        boolean isAttachmentsReported() {
            return BuildTimeReporter.this.outputNonIdentifyingAttachments;
        }
    }

    public static interface SuggestionsBuilder {
        public String build(List<Report> var1, SuggestionBuilderContext var2);
    }
}

