/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.powermock.reflect.internal.proxy.UnproxiedType;
import org.powermock.reflect.internal.proxy.UnproxiedTypeFactory;

public class ProxyFrameworks {
    private static final UnproxiedTypeFactory UNPROXIED_TYPE_FACTORY = new UnproxiedTypeFactory();

    public UnproxiedType getUnproxiedType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (this.isJavaProxy(type)) {
            return UNPROXIED_TYPE_FACTORY.createFromInterfaces(type.getInterfaces());
        }
        if (this.isCglibProxyClass(type)) {
            return UNPROXIED_TYPE_FACTORY.createFromSuperclassAndInterfaces(type.getSuperclass(), type.getInterfaces());
        }
        return UNPROXIED_TYPE_FACTORY.createFromType(type);
    }

    public UnproxiedType getUnproxiedType(Object o) {
        if (o == null) {
            return null;
        }
        return this.getUnproxiedType(o.getClass());
    }

    private boolean isJavaProxy(Class<?> clazz) {
        return clazz != null && Proxy.isProxyClass(clazz);
    }

    private boolean isCglibProxyClass(Class<?> clazz) {
        Method[] methods;
        if (clazz == null) {
            return false;
        }
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!this.isCglibCallbackMethod(m)) continue;
            return true;
        }
        return false;
    }

    private boolean isCglibCallbackMethod(Method m) {
        return "CGLIB$SET_THREAD_CALLBACKS".equals(m.getName()) && m.getParameterTypes().length == 1;
    }
}

