/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.utils;

import java.util.Arrays;
import java.util.List;

public class StringJoiner {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String EMPTY_STRING = "";

    public static String join(Object ... linesToBreak) {
        StringBuilder out = new StringBuilder(LINE_SEPARATOR);
        return StringJoiner.join(out, Arrays.asList(linesToBreak), LINE_SEPARATOR);
    }

    public static <T> String join(List<T> list) {
        StringBuilder out = new StringBuilder(LINE_SEPARATOR);
        return StringJoiner.join(out, list, LINE_SEPARATOR);
    }

    public static String join(String separator, Object ... linesToBreak) {
        StringBuilder out = new StringBuilder();
        return StringJoiner.join(out, linesToBreak, separator);
    }

    private static String join(StringBuilder out, Iterable linesToBreak, String separator) {
        for (Object line : linesToBreak) {
            out.append(line.toString()).append(separator);
        }
        int lastBreak = out.lastIndexOf(separator);
        return out.replace(lastBreak, lastBreak + 1, EMPTY_STRING).toString();
    }
}

