/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.powermock.tests.utils.TestClassesExtractor;

public abstract class AbstractTestClassExtractor
implements TestClassesExtractor {
    protected final boolean includeMethods;

    protected AbstractTestClassExtractor() {
        this(false);
    }

    protected AbstractTestClassExtractor(boolean includeMethods) {
        this.includeMethods = includeMethods;
    }

    @Override
    public final String[] getTestClasses(AnnotatedElement element) {
        HashSet<String> classesToPrepareForTest = new HashSet<String>();
        if (element instanceof Class) {
            this.extractClassesFromTestClass((Class)element, classesToPrepareForTest);
        } else {
            this.extractClassesAndAddThemToList(element, classesToPrepareForTest);
        }
        return classesToPrepareForTest.toArray(new String[classesToPrepareForTest.size()]);
    }

    private void extractClassesFromTestClass(Class<?> element, Set<String> classesToPrepareForTest) {
        for (Class<?> classToInvestigate = element; classToInvestigate != null && !classToInvestigate.equals(Object.class); classToInvestigate = classToInvestigate.getSuperclass()) {
            this.extractClassesAndAddThemToList(classToInvestigate, classesToPrepareForTest);
            if (!this.includeMethods) continue;
            classesToPrepareForTest.addAll(this.lookOverMethods(classToInvestigate));
        }
    }

    private Collection<String> lookOverMethods(Class<?> classToInvestigate) {
        HashSet<String> classesToPrepareForTest = new HashSet<String>();
        for (Method method : classToInvestigate.getMethods()) {
            this.extractClassesAndAddThemToList(method, classesToPrepareForTest);
        }
        return classesToPrepareForTest;
    }

    private void extractClassesAndAddThemToList(AnnotatedElement elementToExtractClassFrom, Set<String> classesToPrepareForTest) {
        String[] classesToModify = this.getClassesToModify(elementToExtractClassFrom);
        if (classesToModify != null) {
            Collections.addAll(classesToPrepareForTest, classesToModify);
        }
    }

    protected abstract String[] getClassesToModify(AnnotatedElement var1);

    @Override
    public boolean isPrepared(AnnotatedElement element, String fullyQualifiedClassName) {
        String[] testClasses;
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("fullyQualifiedClassName cannot be null.");
        }
        for (String className : testClasses = this.getTestClasses(element)) {
            if (!className.equals(fullyQualifiedClassName)) continue;
            return true;
        }
        return false;
    }
}

