/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.Collection;

public class WildcardMatcher {
    private static final char WILDCARD = '*';

    public static boolean matches(String text, String pattern) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null");
        }
        text = text + '\u0000';
        pattern = pattern + '\u0000';
        int N = pattern.length();
        boolean[] states = new boolean[N + 1];
        boolean[] old = new boolean[N + 1];
        old[0] = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            states = new boolean[N + 1];
            for (int j = 0; j < N; ++j) {
                char p = pattern.charAt(j);
                if (old[j] && p == '*') {
                    old[j + 1] = true;
                }
                if (old[j] && p == c) {
                    states[j + 1] = true;
                }
                if (old[j] && p == '*') {
                    states[j] = true;
                }
                if (!old[j] || p != '*') continue;
                states[j + 1] = true;
            }
            old = states;
        }
        return states[N];
    }

    public static boolean matchesAny(Collection<String> patterns, String text) {
        for (String pattern : patterns) {
            if (!WildcardMatcher.matches(text, pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAny(Iterable<String> patterns, String text) {
        for (String string : patterns) {
            if (!WildcardMatcher.matches(text, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAny(String[] patterns, String text) {
        for (String string : patterns) {
            if (!WildcardMatcher.matches(text, string)) continue;
            return true;
        }
        return false;
    }
}

