/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.ConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.WithExpectedArguments;
import org.powermock.api.mockito.internal.invocationcontrol.MockitoNewInvocationControl;
import org.powermock.api.mockito.internal.mockcreation.MockCreator;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConstructorExpectationSetup<T>
implements ConstructorExpectationSetup<T> {
    private Class<?>[] parameterTypes = null;
    private final Class<T> mockType;
    private final ArrayMerger arrayMerger;

    public DefaultConstructorExpectationSetup(Class<T> mockType) {
        this.mockType = mockType;
        this.arrayMerger = new ArrayMergerImpl();
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public OngoingStubbing<T> withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubsituteMock(this.mockType, this.parameterTypes, this.arrayMerger.mergeArrays(Object.class, (Object[][])new Object[][]{{firstArgument}, additionalArguments}));
    }

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return DefaultConstructorExpectationSetup.createNewSubsituteMock(this.mockType, this.parameterTypes, new Object[0]);
    }

    @Override
    public WithExpectedArguments<T> withParameterTypes(Class<?> parameterType, Class<?> ... additionalParameterTypes) {
        this.parameterTypes = (Class[])this.arrayMerger.mergeArrays(Class.class, (Object[][])new Class[][]{{parameterType}, additionalParameterTypes});
        return this;
    }

    private static <T> OngoingStubbing<T> createNewSubsituteMock(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class unmockedType = WhiteboxImpl.getUnmockedType(type);
        if (parameterTypes == null) {
            WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])arguments);
        } else {
            WhiteboxImpl.getConstructor((Class)unmockedType, (Class[])parameterTypes);
        }
        MockitoNewInvocationControl newInvocationControl = MockRepository.getNewInstanceControl((Class)unmockedType);
        if (newInvocationControl == null) {
            InvocationSubstitute mock = MockCreator.mock(InvocationSubstitute.class, false, false, null, null, null);
            newInvocationControl = new MockitoNewInvocationControl(mock);
            MockRepository.putNewInstanceControl(type, newInvocationControl);
            MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{WhiteboxImpl.getUnmockedType(type)});
        }
        return (OngoingStubbing)newInvocationControl.expectSubstitutionLogic(arguments);
    }
}

