/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.windowslive.WindowsLiveProfile;
import org.scribe.builder.api.WindowsLiveApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

public class WindowsLiveClient
extends BaseOAuth20Client<WindowsLiveProfile> {
    public WindowsLiveClient() {
    }

    public WindowsLiveClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected WindowsLiveClient newClient() {
        return new WindowsLiveClient();
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        this.service = new ProxyOAuth20ServiceImpl(new WindowsLiveApi(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, "wl.basic", null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://apis.live.net/v5.0/me";
    }

    @Override
    protected WindowsLiveProfile extractUserProfile(String body) {
        WindowsLiveProfile profile = new WindowsLiveProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.windowsLiveDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

