/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.vk.VkProfile;
import org.scribe.builder.api.VkApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

public class VkClient
extends BaseOAuth20Client<VkProfile> {
    public static final String DEFAULT_FIELDS = "sex,bdate,photo_50,photo_100,photo_200_orig,photo_200,photo_400_orig,photo_max,photo_max_orig,online,online_mobile,lists,domain,has_mobile,contacts,connections,site,education,can_post,can_see_all_posts,can_see_audio,can_write_private_message,status,common_count,relation,relatives";
    protected String fields = "sex,bdate,photo_50,photo_100,photo_200_orig,photo_200,photo_400_orig,photo_max,photo_max_orig,online,online_mobile,lists,domain,has_mobile,contacts,connections,site,education,can_post,can_see_all_posts,can_see_audio,can_write_private_message,status,common_count,relation,relatives";
    public static final String DEFAULT_SCOPE = "PERMISSIONS";
    protected String scope = "PERMISSIONS";
    protected static final String BASE_URL = "https://api.vk.com/method/users.get";

    public VkClient() {
    }

    public VkClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected VkClient newClient() {
        VkClient client = new VkClient();
        client.setScope(this.scope);
        return client;
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        this.service = new ProxyOAuth20ServiceImpl(new VkApi(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, this.scope, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        String url = "https://api.vk.com/method/users.get?fields=" + this.fields;
        return url;
    }

    @Override
    protected VkProfile extractUserProfile(String body) {
        VkProfile profile = new VkProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            ArrayNode array = (ArrayNode)json.get("response");
            JsonNode userNode = array.get(0);
            profile.setId(JsonHelper.get(userNode, "uid"));
            for (String attribute : OAuthAttributesDefinitions.vkDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(userNode, attribute));
            }
        }
        return profile;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }
}

