/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.XmlHelper;
import org.pac4j.oauth.profile.orcid.OrcidProfile;
import org.scribe.builder.api.OrcidApi20;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;
import org.scribe.tokens.OrcidToken;

public class OrcidClient
extends BaseOAuth20Client<OrcidProfile> {
    protected static final String DEFAULT_SCOPE = "/orcid-profile/read-limited";
    protected String scope = "/orcid-profile/read-limited";

    public OrcidClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
        this.setTokenAsHeader(true);
    }

    public OrcidClient() {
        this.setTokenAsHeader(true);
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        String error = context.getRequestParameter("error");
        String errorDescription = context.getRequestParameter("error_description");
        return "access_denied".equals(error) && "User denied access".equals(errorDescription);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        if (accessToken instanceof OrcidToken) {
            return String.format("https://api.orcid.org/v1.1/%s/orcid-profile", ((OrcidToken)accessToken).getOrcid());
        }
        throw new OAuthException("Token in getProfileUrl is not an OrcidToken");
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        this.service = new ProxyOAuth20ServiceImpl(new OrcidApi20(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, this.getScope(), null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, false, true);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    protected OrcidProfile extractUserProfile(String body) {
        OrcidProfile profile = new OrcidProfile();
        for (String attribute : OAuthAttributesDefinitions.orcidDefinition.getAllAttributes()) {
            profile.addAttribute(attribute, XmlHelper.get(body, attribute));
        }
        return profile;
    }

    protected OrcidClient newClient() {
        OrcidClient newClient = new OrcidClient();
        newClient.setScope(this.scope);
        return newClient;
    }
}

