/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.client.BaseOAuthClient;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.ok.OkProfile;
import org.scribe.builder.api.OkApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

public final class OkClient
extends BaseOAuth20Client<OkProfile> {
    private static final String API_BASE_URL = "http://api.ok.ru/fb.do?";
    private String publicKey;

    public OkClient() {
    }

    public OkClient(String key, String secret, String publicKey) {
        this.setKey(key);
        this.setSecret(secret);
        this.setPublicKey(publicKey);
    }

    protected BaseClient<OAuthCredentials, OkProfile> newClient() {
        return new OkClient();
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        String finalSign;
        String baseParams = "application_key=" + this.publicKey + "&format=json" + "&method=users.getCurrentUser";
        try {
            String preSign = this.getMD5SignAsHexString(accessToken.getToken() + this.secret);
            finalSign = this.getMD5SignAsHexString(baseParams.replaceAll("&", "") + preSign);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        return API_BASE_URL + baseParams + "&access_token=" + accessToken.getToken() + "&sig=" + finalSign;
    }

    @Override
    protected OkProfile extractUserProfile(String body) {
        OkProfile profile = new OkProfile();
        JsonNode userNode = JsonHelper.getFirstNode(body);
        if (userNode != null) {
            profile.setId(JsonHelper.get(userNode, "uid"));
            for (String attribute : OAuthAttributesDefinitions.okDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(userNode, attribute));
            }
        }
        return profile;
    }

    private String getMD5SignAsHexString(String strForEncoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        StringBuilder result = new StringBuilder();
        for (byte aByte : md.digest(strForEncoding.getBytes("UTF-8"))) {
            if ((0xFF & aByte) < 16) {
                result.append("0").append(Integer.toHexString(0xFF & aByte));
                continue;
            }
            result.append(Integer.toHexString(0xFF & aByte));
        }
        return result.toString();
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"publicKey", (String)this.publicKey);
        this.service = new ProxyOAuth20ServiceImpl(new OkApi(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort, false, true);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public BaseOAuthClient<OkProfile> clone() {
        OkClient clone = (OkClient)super.clone();
        clone.setPublicKey(this.publicKey);
        return clone;
    }
}

