/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.foursquare.FoursquareProfile;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.builder.api.Foursquare2Api;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.FoursquareOAuth20ServiceImpl;

public class FoursquareClient
extends BaseOAuth20Client<FoursquareProfile> {
    public FoursquareClient() {
    }

    public FoursquareClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected FoursquareClient newClient() {
        return new FoursquareClient();
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        this.service = new FoursquareOAuth20ServiceImpl((DefaultApi20)new Foursquare2Api(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, "user", null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected FoursquareProfile extractUserProfile(String body) {
        FoursquareProfile profile = new FoursquareProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json == null) {
            return profile;
        }
        JsonNode response = (JsonNode)JsonHelper.get(json, "response");
        if (response == null) {
            return profile;
        }
        JsonNode user = (JsonNode)JsonHelper.get(response, "user");
        if (user != null) {
            profile.setId(JsonHelper.get(user, "id"));
            for (String attribute : OAuthAttributesDefinitions.foursquareDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(user, attribute));
            }
        }
        return profile;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://api.foursquare.com/v2/users/self?v=20131118";
    }
}

