/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth10Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.bitbucket.BitbucketProfile;
import org.scribe.builder.api.BitBucketApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth10aServiceImpl;

public class BitbucketClient
extends BaseOAuth10Client<BitbucketProfile> {
    public BitbucketClient() {
    }

    @Override
    protected boolean isDirectRedirection() {
        return true;
    }

    public BitbucketClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void internalInit(WebContext context) {
        super.internalInit(context);
        this.service = new ProxyOAuth10aServiceImpl(new BitBucketApi(), new OAuthConfig(this.key, this.secret, this.computeFinalCallbackUrl(context), SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://bitbucket.org/api/1.0/user/";
    }

    @Override
    protected BitbucketProfile extractUserProfile(String body) {
        BitbucketProfile profile = new BitbucketProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = (JsonNode)JsonHelper.get(json, "user")) != null) {
            for (String attribute : OAuthAttributesDefinitions.bitbucketDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    protected BitbucketClient newClient() {
        return new BitbucketClient();
    }
}

