/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuthClient;
import org.pac4j.oauth.client.exception.OAuthCredentialsException;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuth20Client<U extends OAuth20Profile>
extends BaseOAuthClient<U> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseOAuth20Client.class);
    public static final String OAUTH_CODE = "code";

    @Override
    protected String retrieveAuthorizationUrl(WebContext context) {
        String authorizationUrl = this.service.getAuthorizationUrl(null);
        logger.debug("authorizationUrl : {}", (Object)authorizationUrl);
        return authorizationUrl;
    }

    @Override
    protected OAuthCredentials getOAuthCredentials(WebContext context) {
        String verifierParameter = context.getRequestParameter(OAUTH_CODE);
        if (verifierParameter != null) {
            String verifier = OAuthEncoder.decode((String)verifierParameter);
            logger.debug("verifier : {}", (Object)verifier);
            return new OAuthCredentials(verifier, this.getName());
        }
        String message = "No credential found";
        throw new OAuthCredentialsException("No credential found");
    }

    @Override
    protected Token getAccessToken(OAuthCredentials credentials) {
        String verifier = credentials.getVerifier();
        logger.debug("verifier : {}", (Object)verifier);
        Verifier clientVerifier = new Verifier(verifier);
        Token accessToken = this.service.getAccessToken(null, clientVerifier);
        logger.debug("accessToken : {}", (Object)accessToken);
        return accessToken;
    }

    protected boolean isDirectRedirection() {
        return true;
    }
}

