/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerSingleStagedReactor
implements StagedExamReactor {
    private static final Logger LOG = LoggerFactory.getLogger(EagerSingleStagedReactor.class);
    private final List<TestContainer> targetContainer;
    private final List<TestProbeBuilder> probes;
    private final Map<TestAddress, TestContainer> map = new LinkedHashMap<TestAddress, TestContainer>();

    public EagerSingleStagedReactor(List<TestContainer> containers, List<TestProbeBuilder> mProbes) {
        this.targetContainer = containers;
        this.probes = mProbes;
        int index = 0;
        for (TestContainer container : containers) {
            String caption = this.buildCaption(containers, container, index);
            for (TestProbeBuilder builder : mProbes) {
                for (TestAddress a : builder.getTests()) {
                    this.map.put(new DefaultTestAddress(a, caption, new Object[0]), container);
                }
            }
            ++index;
        }
    }

    private String buildCaption(List<TestContainer> containers, TestContainer container, int index) {
        if (containers.size() == 1) {
            return container.toString();
        }
        return String.format("%s[%d]", container.toString(), index);
    }

    public void setUp() {
        for (TestContainer container : this.targetContainer) {
            container.start();
            for (TestProbeBuilder builder : this.probes) {
                LOG.debug("installing probe " + builder);
                try {
                    container.installProbe(builder.build().getStream());
                }
                catch (IOException e) {
                    throw new TestContainerException("Unable to build the probe.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void invoke(TestAddress address) throws Exception {
        Objects.requireNonNull(address, "TestAddress must not be null.");
        TestContainer testContainer = this.map.get(address);
        if (testContainer == null) {
            throw new IllegalArgumentException("TestAddress " + address + " not from this reactor? Got it from getTargets() really?");
        }
        testContainer.call(address);
    }

    @Override
    public Set<TestAddress> getTargets() {
        return this.map.keySet();
    }

    public void tearDown() {
        for (TestContainer container : this.targetContainer) {
            container.stop();
        }
    }

    @Override
    public void afterSuite() {
    }

    public void afterTest() {
    }

    public void beforeTest() {
    }

    @Override
    public void afterClass() {
        this.tearDown();
    }

    @Override
    public void beforeClass() {
        this.setUp();
    }

    @Override
    public void beforeSuite() {
    }
}

