/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.ops4j.store.Store;
import org.ops4j.store.intern.TemporaryStore;

public class StoreFactory {
    public static final String RELATIVE_STORAGE = "/tb";

    public static Store<InputStream> defaultStore() {
        return StoreFactory.sharedLocalStore();
    }

    public static Store<InputStream> sharedLocalStore() {
        return StoreFactory.newStore(new File(System.getProperty("java.io.tmpdir") + RELATIVE_STORAGE));
    }

    public static Store<InputStream> newStore(File path) {
        return new TemporaryStore(path, false);
    }

    public static Store<InputStream> newStore(File path, boolean flush) {
        return new TemporaryStore(path, flush);
    }

    public static Store<InputStream> anonymousStore() throws IOException {
        File temp = File.createTempFile("ops4j-store-anonymous-", "");
        temp.delete();
        temp.mkdir();
        return new TemporaryStore(temp, true);
    }

    public static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

