/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opengauss.PGProperty;
import org.opengauss.core.QueryExecutor;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;

public class GlobalConnectionTracker {
    private static final Map<String, HashMap<Integer, QueryExecutor>> connectionManager = new HashMap<String, HashMap<Integer, QueryExecutor>>();
    private static Log LOGGER = Logger.getLogger(GlobalConnectionTracker.class.getName());

    private static boolean isForceTargetServerSlave(Properties props) {
        return PGProperty.FORCE_TARGET_SERVER_SLAVE.getBoolean(props) && ("slave".equals(PGProperty.TARGET_SERVER_TYPE.get(props)) || "secondary".equals(PGProperty.TARGET_SERVER_TYPE.get(props)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void possessConnectionReference(QueryExecutor queryExecutor, Properties props) {
        if (!GlobalConnectionTracker.isForceTargetServerSlave(props)) {
            return;
        }
        int identityQueryExecute = System.identityHashCode(queryExecutor);
        String hostSpec = queryExecutor.getHostSpec().toString();
        Map<String, HashMap<Integer, QueryExecutor>> map = connectionManager;
        synchronized (map) {
            HashMap<Integer, QueryExecutor> hostConnection = connectionManager.getOrDefault(hostSpec, null);
            if (hostConnection == null) {
                hostConnection = new HashMap<Integer, QueryExecutor>();
            }
            hostConnection.put(identityQueryExecute, queryExecutor);
            connectionManager.put(hostSpec, hostConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnectionReference(QueryExecutor queryExecutor, Properties props) {
        if (!GlobalConnectionTracker.isForceTargetServerSlave(props)) {
            return;
        }
        String hostSpec = queryExecutor.getHostSpec().toString();
        int identityQueryExecute = System.identityHashCode(queryExecutor);
        Map<String, HashMap<Integer, QueryExecutor>> map = connectionManager;
        synchronized (map) {
            HashMap hostConnection = connectionManager.getOrDefault(hostSpec, null);
            if (hostConnection != null) {
                if (hostConnection.get(identityQueryExecute) != null) {
                    hostConnection.put(identityQueryExecute, null);
                } else {
                    LOGGER.info("[SWITCHOVER] The identity of the queryExecutor has changed!");
                }
            } else {
                LOGGER.info("[SWITCHOVER] No connection found under this host!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeOldConnection(String hostSpec, Properties props) {
        if (!GlobalConnectionTracker.isForceTargetServerSlave(props)) {
            return;
        }
        Map<String, HashMap<Integer, QueryExecutor>> map = connectionManager;
        synchronized (map) {
            HashMap hostConnection = connectionManager.getOrDefault(hostSpec, null);
            if (hostConnection != null) {
                LOGGER.info("[SWITCHOVER] The hostSpec: " + hostSpec + " status from slave to master, start to close the original connection.");
                for (QueryExecutor queryExecutor : hostConnection.values()) {
                    if (queryExecutor == null || queryExecutor.isClosed()) continue;
                    queryExecutor.setAvailability(false);
                }
                hostConnection.clear();
                LOGGER.info("[SWITCHOVER] The hostSpec: " + hostSpec + " status from slave to master, end to close the original connection.");
            }
        }
    }
}

