/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4.mode;

import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.openeuler.sm4.SM4Util;
import org.openeuler.sm4.StreamModeBaseCipher;

public class CTS
extends StreamModeBaseCipher {
    @Override
    public int engineGetOutputSize(int inputLen) {
        if (this.opmode == 1) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
                return inputLen;
            }
            return inputLen + 16 - inputLen % 16;
        }
        if (this.opmode == 2) {
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
                return inputLen;
            }
            if (inputLen % 16 != 0) {
                return 0;
            }
            return inputLen;
        }
        return 0;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return 0;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return 0;
            }
            if (inputLen % 16 != 0) {
                this.len = inputLen - (16 + inputLen % 16);
            } else {
                if (inputLen == 16) {
                    this.len = 0;
                    return 0;
                }
                this.len = inputLen - 32;
            }
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return 0;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        if (outputOffset + this.len > output.length) {
            throw new ShortBufferException();
        }
        if (this.opmode == 1) {
            this.encryptCTS(input, inputOffset, this.len, output, outputOffset);
        } else if (this.opmode == 2) {
            this.decryptCTS(input, inputOffset, this.len, output, outputOffset);
        }
        return this.len;
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        if (input == null || inputLen == 0) {
            return null;
        }
        this.inputUpdate = input;
        this.inputLenUpdate = inputLen;
        this.inputOffsetUpdate = inputOffset;
        byte[] res = null;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen < 16) {
                this.len = 0;
                return null;
            }
            if (inputLen % 16 != 0) {
                this.len = inputLen - (16 + inputLen % 16);
                if (this.len == 0) {
                    return null;
                }
            } else {
                if (inputLen == 16) {
                    this.len = 0;
                    return null;
                }
                this.len = inputLen - 32;
                if (this.len == 0) {
                    return null;
                }
            }
        } else {
            if (inputLen <= 16) {
                this.len = 0;
                return null;
            }
            this.len = inputLen % 16 == 0 ? inputLen - 16 : inputLen - inputLen % 16;
        }
        res = new byte[this.len];
        if (this.opmode == 1) {
            this.encryptCTS(input, inputOffset, this.len, res, 0);
        } else if (this.opmode == 2) {
            this.decryptCTS(input, inputOffset, this.len, res, 0);
        }
        return res;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        byte[] res = null;
        int restLen = this.inputLenUpdate - this.len;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && restLen + inputLen < 16) {
            throw new IllegalBlockSizeException("CTS nopadding need at least 1 block input.");
        }
        if (this.opmode == 1) {
            int length = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            res = new byte[length];
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, res, 0);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                this.encrypt(allInput, 0, allInput.length, res, 0);
            }
        } else if (this.opmode == 2) {
            if (restLen == 0) {
                res = this.decrypt(input, inputOffset, inputLen);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                res = this.decrypt(allInput, 0, allInput.length);
            }
        }
        this.reset();
        return res;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInitialized) {
            throw new IllegalStateException("cipher uninitialized");
        }
        int restLen = this.inputLenUpdate - this.len;
        int need = 0;
        if (this.opmode == 1) {
            int length;
            if (this.padding.getPadding().toUpperCase().equals("NOPADDING") && restLen + inputLen < 16) {
                throw new IllegalBlockSizeException("CTS nopadding need at least 1 block plainText");
            }
            need = length = this.engineGetOutputSize(this.inputLenUpdate - this.len + inputLen);
            if (restLen == 0) {
                this.encrypt(input, inputOffset, inputLen, output, outputOffset);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                this.encrypt(allInput, 0, allInput.length, output, outputOffset);
            }
        } else if (this.opmode == 2) {
            if (restLen == 0) {
                need = this.decrypt(input, inputOffset, inputLen, output, outputOffset);
            } else {
                byte[] allInput = new byte[restLen + inputLen];
                SM4Util.copyArray(this.inputUpdate, this.inputOffsetUpdate + this.len, restLen, allInput, 0);
                SM4Util.copyArray(input, inputOffset, inputLen, allInput, restLen);
                need = this.decrypt(allInput, 0, allInput.length, output, outputOffset);
            }
        }
        this.reset();
        return need;
    }

    private void decryptCTS(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int i = inputOffset;
        while (i + 16 <= inputOffset + inputLen) {
            byte[] decrypt = this.sm4.decrypt(this.rk, input, i);
            byte[] xor = this.sm4.xor(decrypt, this.counter);
            SM4Util.copyArray(input, i, 16, this.counter, 0);
            SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
    }

    private void encryptCTS(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int i = inputOffset;
        while (i + 16 <= inputOffset + inputLen) {
            byte[] xor = this.sm4.xor(this.counter, 0, this.counter.length, input, i, 16);
            byte[] encrypt = this.sm4.encrypt(this.rk, xor);
            this.counter = encrypt;
            SM4Util.copyArray(encrypt, 0, encrypt.length, output, outputOffset + i - inputOffset);
            i += 16;
        }
    }

    private void encrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            if (inputLen % 16 != 0) {
                int i = inputOffset;
                while (i + 16 <= inputOffset + inputLen) {
                    byte[] xor = null;
                    xor = this.sm4.xor(input, i, 16, this.counter, 0, 16);
                    byte[] encrypt = this.sm4.encrypt(this.rk, xor, 0);
                    this.counter = encrypt;
                    if (i + 32 <= inputLen + inputOffset) {
                        SM4Util.copyArray(encrypt, 0, encrypt.length, output, outputOffset + i - inputOffset);
                    }
                    i += 16;
                }
                int needLen = 16 - inputLen % 16;
                byte[] xor = this.sm4.xor(input, inputOffset + inputLen - inputLen % 16, inputLen % 16, this.counter, 0, 16);
                byte[] block = new byte[16];
                SM4Util.copyArray(xor, 0, xor.length, block, 0);
                SM4Util.copyArray(this.counter, this.counter.length - needLen, needLen, block, block.length - needLen);
                byte[] encrypt = this.sm4.encrypt(this.rk, block, 0);
                SM4Util.copyArray(encrypt, 0, encrypt.length, output, outputOffset + i - inputOffset - 16);
                SM4Util.copyArray(this.counter, 0, inputLen % 16, output, outputOffset + i - inputOffset);
            } else {
                int i = inputOffset;
                while (i + 16 <= inputLen + inputOffset) {
                    byte[] xor = null;
                    xor = this.sm4.xor(input, i, 16, this.counter, 0, 16);
                    byte[] encrypt = this.sm4.encrypt(this.rk, xor, 0);
                    this.counter = encrypt;
                    SM4Util.copyArray(encrypt, 0, encrypt.length, output, outputOffset + i - inputOffset);
                    i += 16;
                }
                if (inputLen != 16) {
                    for (int i2 = 0; i2 < 16; ++i2) {
                        byte tmp = output[outputOffset + inputLen - 32 + i2];
                        output[outputOffset + inputLen - 32 + i2] = output[outputOffset + inputLen - 16 + i2];
                        output[outputOffset + inputLen - 16 + i2] = tmp;
                    }
                }
            }
        } else {
            byte[] encrypt;
            byte[] xor;
            int i = inputOffset;
            while (i + 16 <= inputOffset + inputLen) {
                byte[] xor2 = this.sm4.xor(this.counter, 0, this.counter.length, input, i, 16);
                byte[] encrypt2 = this.sm4.encrypt(this.rk, xor2);
                this.counter = encrypt2;
                SM4Util.copyArray(encrypt2, 0, encrypt2.length, output, outputOffset + i - inputOffset);
                i += 16;
            }
            if (inputLen % 16 != 0) {
                byte[] fill = this.padding.fill(input, i, inputLen % 16);
                xor = this.sm4.xor(this.counter, fill);
                encrypt = this.sm4.encrypt(this.rk, xor);
                this.counter = encrypt;
                SM4Util.copyArray(encrypt, 0, encrypt.length, output, outputOffset + (i - inputOffset));
            }
            if (inputLen % 16 == 0) {
                byte[] block = new byte[16];
                Arrays.fill(block, (byte)16);
                xor = this.sm4.xor(this.counter, block);
                encrypt = this.sm4.encrypt(this.rk, xor);
                this.counter = encrypt;
                SM4Util.copyArray(encrypt, 0, encrypt.length, output, outputOffset + (i - inputOffset));
            }
        }
    }

    private byte[] decrypt(byte[] input, int inputOffset, int inputLen) throws BadPaddingException {
        byte[] res = null;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            res = new byte[inputLen];
            if (inputLen % 16 != 0) {
                byte[] xor;
                int needLen = 16 - inputLen % 16;
                int i = inputOffset;
                while (i + 16 <= inputLen + inputOffset) {
                    byte[] decrypt = this.sm4.decrypt(this.rk, input, i);
                    if (i + 32 <= inputOffset + inputLen) {
                        xor = null;
                        xor = this.sm4.xor(decrypt, this.counter);
                        SM4Util.copyArray(input, i, 16, this.counter, 0);
                        SM4Util.copyArray(xor, 0, xor.length, res, i - inputOffset);
                    } else {
                        byte[] block = new byte[16];
                        SM4Util.copyArray(input, inputOffset + inputLen - inputLen % 16, inputLen % 16, block, 0);
                        SM4Util.copyArray(decrypt, decrypt.length - needLen, needLen, block, block.length - needLen);
                        byte[] decrypt1 = this.sm4.decrypt(this.rk, block, 0);
                        byte[] xor2 = this.sm4.xor(decrypt1, this.counter);
                        SM4Util.copyArray(xor2, 0, xor2.length, res, i - inputOffset);
                        this.counter = decrypt;
                    }
                    i += 16;
                }
                byte[] e = Arrays.copyOfRange(input, inputLen + inputOffset - inputLen % 16, inputLen + inputOffset);
                xor = this.sm4.xor(e, this.counter);
                SM4Util.copyArray(xor, 0, xor.length, res, res.length - xor.length);
            } else {
                byte tmp;
                if (inputLen != 16) {
                    for (int i = 0; i < 16; ++i) {
                        tmp = input[inputLen + inputOffset - 32 + i];
                        input[inputLen + inputOffset - 32 + i] = input[inputOffset + inputLen - 16 + i];
                        input[inputOffset + inputLen - 16 + i] = tmp;
                    }
                }
                int i = inputOffset;
                while (i + 16 <= inputLen + inputOffset) {
                    byte[] decrypt = this.sm4.decrypt(this.rk, input, i);
                    byte[] xor = null;
                    xor = this.sm4.xor(decrypt, this.counter);
                    SM4Util.copyArray(input, i, 16, this.counter, 0);
                    SM4Util.copyArray(xor, 0, xor.length, res, i - inputOffset);
                    i += 16;
                }
                if (inputLen != 16) {
                    for (int i2 = 0; i2 < 16; ++i2) {
                        tmp = input[inputLen + inputOffset - 32 + i2];
                        input[inputLen + inputOffset - 32 + i2] = input[inputOffset + inputLen - 16 + i2];
                        input[inputOffset + inputLen - 16 + i2] = tmp;
                    }
                }
            }
        } else if (inputLen == 16) {
            byte[] decrypt = this.sm4.decrypt(this.rk, input, inputOffset);
            byte[] xor = null;
            xor = this.sm4.xor(decrypt, this.counter);
            byte[] recover = this.padding.recover(xor);
            res = new byte[recover.length];
            SM4Util.copyArray(recover, 0, recover.length, res, res.length - recover.length);
        } else {
            byte[] last128bit = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
            byte[] last128BitPlainTextWithPadding = this.sm4.xor(last128bit, 0, 16, input, inputLen + inputOffset - 32, 16);
            byte[] lastNoPaddingPlainText = this.padding.recover(last128BitPlainTextWithPadding);
            res = new byte[inputLen - 16 + lastNoPaddingPlainText.length];
            SM4Util.copyArray(lastNoPaddingPlainText, 0, lastNoPaddingPlainText.length, res, res.length - lastNoPaddingPlainText.length);
            this.decryptCTS(input, inputOffset, inputLen - 16, res, 0);
        }
        return res;
    }

    private int decrypt(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws BadPaddingException, ShortBufferException {
        int need = 0;
        if (this.padding.getPadding().toUpperCase().equals("NOPADDING")) {
            need = inputLen;
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            if (inputLen % 16 != 0) {
                byte[] xor;
                int needLen = 16 - inputLen % 16;
                int i = inputOffset;
                while (i + 16 <= inputLen + inputOffset) {
                    byte[] decrypt = this.sm4.decrypt(this.rk, input, i);
                    if (i + 32 <= inputOffset + inputLen) {
                        xor = null;
                        xor = this.sm4.xor(decrypt, this.counter);
                        SM4Util.copyArray(input, i, 16, this.counter, 0);
                        SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
                    } else {
                        byte[] block = new byte[16];
                        SM4Util.copyArray(input, inputOffset + inputLen - inputLen % 16, inputLen % 16, block, 0);
                        SM4Util.copyArray(decrypt, decrypt.length - needLen, needLen, block, block.length - needLen);
                        byte[] decrypt1 = this.sm4.decrypt(this.rk, block, 0);
                        byte[] xor2 = this.sm4.xor(decrypt1, this.counter);
                        SM4Util.copyArray(xor2, 0, xor2.length, output, outputOffset + i - inputOffset);
                        this.counter = decrypt;
                    }
                    i += 16;
                }
                byte[] e = Arrays.copyOfRange(input, inputLen + inputOffset - inputLen % 16, inputLen + inputOffset);
                xor = this.sm4.xor(e, this.counter);
                SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + need - xor.length);
            } else {
                byte tmp;
                if (inputLen != 16) {
                    for (int i = 0; i < 16; ++i) {
                        tmp = input[inputLen + inputOffset - 32 + i];
                        input[inputLen + inputOffset - 32 + i] = input[inputOffset + inputLen - 16 + i];
                        input[inputOffset + inputLen - 16 + i] = tmp;
                    }
                }
                int i = inputOffset;
                while (i + 16 <= inputLen + inputOffset) {
                    byte[] decrypt = this.sm4.decrypt(this.rk, input, i);
                    byte[] xor = null;
                    xor = this.sm4.xor(decrypt, this.counter);
                    SM4Util.copyArray(input, i, 16, this.counter, 0);
                    SM4Util.copyArray(xor, 0, xor.length, output, outputOffset + i - inputOffset);
                    i += 16;
                }
                if (inputLen != 16) {
                    for (int i2 = 0; i2 < 16; ++i2) {
                        tmp = input[inputLen + inputOffset - 32 + i2];
                        input[inputLen + inputOffset - 32 + i2] = input[inputOffset + inputLen - 16 + i2];
                        input[inputOffset + inputLen - 16 + i2] = tmp;
                    }
                }
            }
        } else if (inputLen == 16) {
            byte[] decrypt = this.sm4.decrypt(this.rk, input, inputOffset);
            byte[] xor = null;
            xor = this.sm4.xor(decrypt, this.counter);
            byte[] recover = this.padding.recover(xor);
            need = recover.length;
            if (outputOffset + need > output.length) {
                throw new ShortBufferException();
            }
            SM4Util.copyArray(recover, 0, recover.length, output, outputOffset + need - recover.length);
        } else {
            byte[] last128bit = this.sm4.decrypt(this.rk, input, inputOffset + inputLen - 16);
            byte[] last128BitPlainTextWithPadding = this.sm4.xor(last128bit, 0, 16, input, inputLen + inputOffset - 32, 16);
            byte[] lastNoPaddingPlainText = this.padding.recover(last128BitPlainTextWithPadding);
            need = inputLen - 16 + lastNoPaddingPlainText.length;
            SM4Util.copyArray(lastNoPaddingPlainText, 0, lastNoPaddingPlainText.length, output, outputOffset + need - lastNoPaddingPlainText.length);
            this.decryptCTS(input, inputOffset, inputLen - 16, output, outputOffset);
        }
        return need;
    }

    @Override
    public void reset() {
        super.reset();
        SM4Util.copyArray(this.iv, 0, this.iv.length, this.counter, 0);
    }
}

