/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.openeuler.BGMJCEProvider;

public class SM4KeyGenerator
extends KeyGeneratorSpi {
    private byte[] key;
    private int keySize = 16;
    private SecureRandom random;

    @Override
    protected void engineInit(SecureRandom random) {
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("SM4 key generation does not take any parameters");
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (keysize != 128) {
            throw new InvalidParameterException("SM4 requires a 128 bit key");
        }
        this.keySize = keysize / 8;
        this.engineInit(random);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        this.key = new byte[this.keySize];
        if (this.random == null) {
            this.random = BGMJCEProvider.getRandom();
        }
        this.random.nextBytes(this.key);
        return new SecretKeySpec(this.key, "SM4");
    }
}

