/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.tool.merge;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentException;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.layout.PageLayout;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.ResourceManage;

public class DocContext
implements Closeable {
    public final OFDReader reader;
    public final ResourceManage resMgt;
    public final Path filepath;
    final Map<String, OFDElement> resOldNewMap;
    private CT_PageArea defaultArea;

    public DocContext(Path filepath) throws IOException {
        this.filepath = filepath;
        this.reader = new OFDReader(filepath);
        this.resMgt = this.reader.getResMgt();
        this.resOldNewMap = new HashMap<String, OFDElement>();
    }

    public CT_PageArea getDefaultArea(int numOfDoc) throws DocumentException, FileNotFoundException {
        if (this.defaultArea != null) {
            return this.defaultArea;
        }
        Document document = this.reader.getDoc(numOfDoc);
        this.defaultArea = document.getCommonData().getPageArea();
        if (this.defaultArea == null) {
            this.defaultArea = PageLayout.A4().getPageArea();
        }
        return this.defaultArea;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

