/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ofdrw.core.basicStructure.pageObj.Content;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.extractor.ExtractorFilter;

public class ContentExtractor {
    private OFDReader reader;
    private ExtractorFilter filter;

    private ContentExtractor() {
    }

    public ContentExtractor(OFDReader reader) {
        this.reader = reader;
    }

    public ContentExtractor(OFDReader reader, ExtractorFilter filter) {
        this.reader = reader;
        this.filter = filter;
    }

    public List<String> getPageContent(int pageNum) {
        Content ofdContentObj = this.reader.getPage(pageNum).getContent();
        if (ofdContentObj == null) {
            return Collections.emptyList();
        }
        LinkedList<String> txtContentList = new LinkedList<String>();
        List layers = ofdContentObj.getLayers();
        for (CT_Layer layer : layers) {
            this.pageBlockHandle(txtContentList, layer.getPageBlocks());
        }
        return txtContentList;
    }

    public List<TextObject> getPageTextObject(int pageNum) {
        Content ofdContentObj = this.reader.getPage(pageNum).getContent();
        if (ofdContentObj == null) {
            return Collections.emptyList();
        }
        LinkedList<TextObject> txtContentList = new LinkedList<TextObject>();
        List layers = ofdContentObj.getLayers();
        for (CT_Layer layer : layers) {
            this.pageBlockTextObjectHandle(txtContentList, layer.getPageBlocks());
        }
        return txtContentList;
    }

    private void pageBlockHandle(List<String> txtContentList, List<PageBlockType> pageBlocks) {
        for (PageBlockType block : pageBlocks) {
            if (block instanceof TextObject) {
                TextObject text = (TextObject)block;
                List textCodes = text.getTextCodes();
                for (TextCode code : textCodes) {
                    if (this.filter != null) {
                        String allowText = this.filter.getAllowText(text, code);
                        if (allowText == null || "".equals(allowText.trim())) continue;
                        txtContentList.add(allowText);
                        continue;
                    }
                    txtContentList.add(code.getContent());
                }
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            CT_PageBlock ctPageBlock = (CT_PageBlock)block;
            this.pageBlockHandle(txtContentList, ctPageBlock.getPageBlocks());
        }
    }

    private void pageBlockTextObjectHandle(List<TextObject> textObjectList, List<PageBlockType> pageBlocks) {
        block0: for (PageBlockType block : pageBlocks) {
            if (block instanceof TextObject) {
                TextObject text = (TextObject)block;
                List textCodes = text.getTextCodes();
                if (this.filter != null) {
                    for (TextCode code : textCodes) {
                        String allowText = this.filter.getAllowText(text, code);
                        if (allowText == null || "".equals(allowText.trim())) continue;
                        textObjectList.add(text);
                        continue block0;
                    }
                    continue;
                }
                textObjectList.add(text);
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            CT_PageBlock ctPageBlock = (CT_PageBlock)block;
            this.pageBlockTextObjectHandle(textObjectList, ctPageBlock.getPageBlocks());
        }
    }

    public List<String> extractAll() {
        int numberOfPages = this.reader.getNumberOfPages();
        LinkedList<String> txtContentList = new LinkedList<String>();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            List<String> pageContent = this.getPageContent(pageNum);
            if (pageContent == null || pageContent.isEmpty()) continue;
            txtContentList.addAll(pageContent);
        }
        return txtContentList;
    }

    public List<TextObject> extractAllTextObject() {
        int numberOfPages = this.reader.getNumberOfPages();
        LinkedList<TextObject> txtObjectList = new LinkedList<TextObject>();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            List<TextObject> pageTextObject = this.getPageTextObject(pageNum);
            if (pageTextObject == null || pageTextObject.isEmpty()) continue;
            txtObjectList.addAll(pageTextObject);
        }
        return txtObjectList;
    }

    public void traverse(Receiver e) {
        int numberOfPages = this.reader.getNumberOfPages();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            List<String> pageContent = this.getPageContent(pageNum);
            if (pageContent == null || pageContent.isEmpty() || e == null) continue;
            e.process(pageNum, pageContent);
        }
    }

    @FunctionalInterface
    public static interface Receiver {
        public void process(int var1, List<String> var2);
    }
}

