/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.engine.render;

import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.engine.GraphHelper;

public class DivRender {
    public static void render(CT_PageBlock layer, Div e, AtomicInteger maxUnitID) {
        int[] bgColor = e.getBackgroundColor();
        if (bgColor == null && e.isNoBorder()) {
            return;
        }
        Integer alpha = null;
        if (e.getOpacity() != null) {
            alpha = (int)(e.getOpacity() * 255.0);
        }
        if (e.getHeight() == null) {
            throw new IllegalArgumentException("Div\u5143\u7d20\u7684\u9ad8\u5ea6\u5fc5\u987b\u6307\u5b9a");
        }
        double eleContentHeight = e.getPaddingTop() + e.getHeight() + e.getPaddingBottom();
        if (bgColor != null && eleContentHeight > 0.0) {
            ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
            PathObject bg = new PathObject(objId);
            double x = e.getX() + e.getMarginLeft() + e.getBorderLeft();
            double y = e.getY() + e.getMarginTop() + e.getBorderTop();
            double w = e.getPaddingLeft() + e.getWidth() + e.getPaddingRight();
            ((CT_Path)bg.setBoundary(x, y, w, eleContentHeight)).setAbbreviatedData(GraphHelper.rect(0.0, 0.0, w, eleContentHeight)).setStroke(Boolean.valueOf(false)).setFill(Boolean.valueOf(true)).setFillColor(CT_Color.rgb((int[])bgColor));
            if (alpha != null) {
                bg.setAlpha(alpha);
            }
            layer.addPageBlock((PageBlockType)bg);
        }
        if (!e.isNoBorder()) {
            double y;
            double x;
            if (e.getBorderTop().equals(e.getBorderRight()) && e.getBorderRight().equals(e.getBorderBottom()) && e.getBorderBottom().equals(e.getBorderLeft())) {
                double lineWidth = e.getBorderTop();
                ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                PathObject border = new PathObject(objId);
                x = e.getX() + e.getMarginLeft();
                y = e.getY() + e.getMarginTop();
                double w = lineWidth + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight() + lineWidth;
                double h = lineWidth + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom() + lineWidth;
                ((CT_Path)((CT_Path)border.setBoundary(x, y, w, h)).setLineWidth(Double.valueOf(lineWidth))).setAbbreviatedData(GraphHelper.rect(lineWidth / 2.0, lineWidth / 2.0, w - lineWidth, h - lineWidth));
                int[] borderColor = e.getBorderColor();
                if (borderColor != null) {
                    border.setStrokeColor(CT_Color.rgb((int[])borderColor));
                }
                if (alpha != null) {
                    border.setAlpha(alpha);
                }
                layer.addPageBlock((PageBlockType)border);
            } else {
                double rightWidth;
                double bottomWidth;
                double topWidth = e.getBorderTop();
                if (topWidth != 0.0) {
                    ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                    PathObject topBorder = new PathObject(objId);
                    x = e.getX() + e.getMarginLeft();
                    y = e.getY() + e.getMarginTop();
                    double w = e.getBorderLeft() + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight() + e.getBorderRight();
                    ((CT_Path)((CT_Path)topBorder.setBoundary(x, y, w, topWidth)).setLineWidth(Double.valueOf(topWidth))).setAbbreviatedData(new AbbreviatedData().M(0.0, topWidth / 2.0).L(w, topWidth / 2.0));
                    int[] borderColor = e.getBorderColor();
                    if (borderColor != null) {
                        topBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                    }
                    if (alpha != null) {
                        topBorder.setAlpha(alpha);
                    }
                    layer.addPageBlock((PageBlockType)topBorder);
                }
                if ((bottomWidth = e.getBorderBottom().doubleValue()) != 0.0) {
                    ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                    PathObject bottomBorder = new PathObject(objId);
                    double x2 = e.getX() + e.getMarginLeft();
                    double y2 = e.getY() + e.getMarginTop() + e.getBorderTop() + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom();
                    double w = e.getBorderLeft() + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight() + e.getBorderRight();
                    ((CT_Path)((CT_Path)bottomBorder.setBoundary(x2, y2, w, bottomWidth)).setLineWidth(Double.valueOf(bottomWidth))).setAbbreviatedData(new AbbreviatedData().M(0.0, bottomWidth / 2.0).L(w, bottomWidth / 2.0));
                    int[] borderColor = e.getBorderColor();
                    if (borderColor != null) {
                        bottomBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                    }
                    if (alpha != null) {
                        bottomBorder.setAlpha(alpha);
                    }
                    layer.addPageBlock((PageBlockType)bottomBorder);
                }
                if (topWidth + bottomWidth + eleContentHeight == 0.0) {
                    return;
                }
                double leftWidth = e.getBorderLeft();
                if (leftWidth != 0.0) {
                    ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                    PathObject leftBorder = new PathObject(objId);
                    double x3 = e.getX() + e.getMarginLeft();
                    double y3 = e.getY() + e.getMarginTop() + topWidth;
                    double h = e.getBorderTop() + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom() + e.getBorderBottom() - topWidth - bottomWidth;
                    ((CT_Path)((CT_Path)leftBorder.setBoundary(x3, y3, leftWidth, h)).setLineWidth(Double.valueOf(leftWidth))).setAbbreviatedData(new AbbreviatedData().M(leftWidth / 2.0, 0.0).L(leftWidth / 2.0, h));
                    int[] borderColor = e.getBorderColor();
                    if (borderColor != null) {
                        leftBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                    }
                    if (alpha != null) {
                        leftBorder.setAlpha(alpha);
                    }
                    layer.addPageBlock((PageBlockType)leftBorder);
                }
                if ((rightWidth = e.getBorderRight().doubleValue()) != 0.0) {
                    ST_ID objId = new ST_ID((long)maxUnitID.incrementAndGet());
                    PathObject rightBorder = new PathObject(objId);
                    double x4 = e.getX() + e.getMarginLeft() + e.getBorderLeft() + e.getPaddingLeft() + e.getWidth() + e.getPaddingRight();
                    double y4 = e.getY() + e.getMarginTop() + topWidth;
                    double h = e.getBorderTop() + e.getPaddingTop() + e.getHeight() + e.getPaddingBottom() + e.getBorderBottom() - topWidth - bottomWidth;
                    ((CT_Path)((CT_Path)rightBorder.setBoundary(x4, y4, rightWidth, h)).setLineWidth(Double.valueOf(rightWidth))).setAbbreviatedData(new AbbreviatedData().M(rightWidth / 2.0, 0.0).L(rightWidth / 2.0, h));
                    int[] borderColor = e.getBorderColor();
                    if (borderColor != null) {
                        rightBorder.setStrokeColor(CT_Color.rgb((int[])borderColor));
                    }
                    if (alpha != null) {
                        rightBorder.setAlpha(alpha);
                    }
                    layer.addPageBlock((PageBlockType)rightBorder);
                }
            }
        }
    }
}

