/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import org.ofdrw.font.EnvFont;
import org.ofdrw.font.Font;
import org.ofdrw.font.FontName;
import org.ofdrw.layout.element.TextFontInfo;
import org.ofdrw.layout.element.canvas.TextAlign;

public class FontSetting
implements Cloneable,
TextFontInfo {
    private Font fontObj;
    private double fontSize;
    private boolean italic = false;
    private Integer fontWeight = 400;
    private double letterSpacing = 0.0;
    private int charDirection = 0;
    private int readDirection = 0;
    private TextAlign textAlign = TextAlign.start;
    private java.awt.Font awtFont;

    public static FontSetting getInstance() {
        return new FontSetting(5.0, FontName.SimSun.font());
    }

    public static FontSetting getInstance(double fontSize) {
        return new FontSetting(fontSize, FontName.SimSun.font());
    }

    public FontSetting(double fontSize, Font fontObj) {
        if (fontObj == null) {
            throw new IllegalArgumentException("\u5b57\u4f53\u5bf9\u8c61(fontObj)\u4e3a\u7a7a");
        }
        this.fontObj = fontObj;
        this.fontSize = fontSize;
        this.awtFont = null;
    }

    private FontSetting() {
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public FontSetting setTextAlign(TextAlign textAlign) {
        if (textAlign == null) {
            return this;
        }
        this.textAlign = textAlign;
        return this;
    }

    @Override
    public Font getFont() {
        return this.fontObj;
    }

    public FontSetting setFont(Font fontObj) {
        if (fontObj == null) {
            throw new IllegalArgumentException("\u5b57\u4f53\u5bf9\u8c61(fontObj)\u4e3a\u7a7a");
        }
        this.fontObj = fontObj;
        this.awtFont = null;
        return this;
    }

    @Override
    public Double getFontSize() {
        return this.fontSize;
    }

    public FontSetting setFontSize(double fontSize) {
        this.fontSize = fontSize;
        this.awtFont = null;
        return this;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public FontSetting setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public FontSetting setBold() {
        this.setFontWeight(800);
        return this;
    }

    public Integer getFontWeight() {
        return this.fontWeight;
    }

    public int getCharDirection() {
        return this.charDirection;
    }

    public FontSetting setCharDirection(int charDirection) {
        if (charDirection != 0 && charDirection != 90 && charDirection != 180 && charDirection != 270) {
            throw new IllegalArgumentException("\u5b57\u7b26\u65b9\u5411(charDirection) \u5141\u8bb8\u503c\uff1a0\u300190\u3001180\u3001270\uff0c\u9519\u8bef\u503c\uff1a" + charDirection);
        }
        this.charDirection = charDirection;
        return this;
    }

    public int getReadDirection() {
        return this.readDirection;
    }

    @Override
    public Double getLetterSpacing() {
        return this.letterSpacing;
    }

    public FontSetting setLetterSpacing(double letterSpacing) {
        if (letterSpacing < 0.0) {
            letterSpacing = 0.0;
        }
        this.letterSpacing = letterSpacing;
        return this;
    }

    public FontSetting setReadDirection(int readDirection) {
        if (readDirection != 0 && readDirection != 90 && readDirection != 180 && readDirection != 270) {
            throw new IllegalArgumentException("\u9605\u8bfb\u65b9\u5411(readDirection) \u5141\u8bb8\u503c\uff1a0\u300190\u3001180\u3001270\uff0c\u9519\u8bef\u503c\uff1a" + readDirection);
        }
        this.readDirection = readDirection;
        return this;
    }

    public FontSetting setFontWeight(Integer fontWeight) {
        switch (fontWeight) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: {
                this.fontWeight = fontWeight;
                break;
            }
            default: {
                throw new NumberFormatException("\u5b57\u4f53\u5bbd\u5ea6(fontWeight)\u53ef\u9009\u503c\uff1a 100\u3001200\u3001300\u3001400\u3001500\u3001600\u3001700\u3001800\u3001900");
            }
        }
        return this;
    }

    public Double charWidth(char c) {
        if (this.fontObj.hasWidthMath()) {
            return this.fontObj.getCharWidthScale(c) * this.fontSize;
        }
        if (this.awtFont == null) {
            this.awtFont = this.fontObj.getFontObj();
            if (this.awtFont == null) {
                this.awtFont = EnvFont.getFont((String)this.fontObj.getName(), (String)this.fontObj.getFamilyName());
            }
            if (this.awtFont == null) {
                this.awtFont = EnvFont.getDefaultFont();
            }
            this.awtFont = this.awtFont.deriveFont((float)this.fontSize);
        }
        return this.awtFont.getStringBounds(String.valueOf(c), EnvFont.FRCtx()).getWidth();
    }

    public FontSetting clone() {
        return new FontSetting().setFont(this.fontObj).setItalic(this.italic).setFontSize(this.fontSize).setFontWeight(this.fontWeight).setCharDirection(this.charDirection).setReadDirection(this.readDirection).setTextAlign(this.textAlign);
    }
}

