/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element;

import java.util.LinkedList;
import java.util.List;
import org.ofdrw.font.Font;
import org.ofdrw.layout.Rectangle;
import org.ofdrw.layout.element.Clear;
import org.ofdrw.layout.element.Div;
import org.ofdrw.layout.element.PlaceholderSpan;
import org.ofdrw.layout.element.Span;
import org.ofdrw.layout.element.TextAlign;
import org.ofdrw.layout.element.TxtLineBlock;

public class Paragraph
extends Div<Paragraph> {
    private Integer firstLineIndent = null;
    private Double firstLineIndentWidth = null;
    private Double lineSpace = 2.0;
    private Font defaultFont;
    private Double defaultFontSize;
    private LinkedList<Span> contents;
    private LinkedList<TxtLineBlock> lines;
    private TextAlign textAlign = TextAlign.left;

    public Paragraph(Double width, Double height) {
        this();
        ((Paragraph)this.setWidth(width)).setHeight(height);
    }

    public Paragraph() {
        this.setClear(Clear.both);
        this.contents = new LinkedList();
        this.lines = new LinkedList();
    }

    public Paragraph(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.contents = new LinkedList();
        this.lines = new LinkedList();
    }

    public Paragraph(double x, double y, double width, double height, String text, double fontSize) {
        super(x, y, width, height);
        if (text == null) {
            throw new IllegalArgumentException("\u6587\u5b57\u5185\u5bb9\u4e3anull");
        }
        this.contents = new LinkedList();
        this.lines = new LinkedList();
        this.setFontSize(fontSize);
        this.add(text);
    }

    public Paragraph(String text) {
        this();
        if (text == null) {
            throw new IllegalArgumentException("\u6587\u5b57\u5185\u5bb9\u4e3anull");
        }
        this.add(text);
    }

    public Paragraph(String text, Double defaultFontSize) {
        this();
        if (text == null) {
            throw new IllegalArgumentException("\u6587\u5b57\u5185\u5bb9\u4e3anull");
        }
        this.setFontSize(defaultFontSize);
        this.add(text);
    }

    public Paragraph(String text, Double defaultFontSize, Font defaultFont) {
        this();
        if (text == null) {
            throw new IllegalArgumentException("\u6587\u5b57\u5185\u5bb9\u4e3anull");
        }
        this.setFontSize(defaultFontSize);
        this.setDefaultFont(defaultFont);
        this.add(text);
    }

    public Paragraph(String text, Font defaultFont) {
        this();
        if (text == null) {
            throw new IllegalArgumentException("\u6587\u5b57\u5185\u5bb9\u4e3anull");
        }
        this.setDefaultFont(defaultFont);
        this.add(text);
    }

    public Paragraph add(String text) {
        if (text == null) {
            return this;
        }
        Span newTxt = new Span(text);
        if (this.defaultFont != null) {
            newTxt.setFont(this.defaultFont);
        }
        if (this.defaultFontSize != null) {
            newTxt.setFontSize(this.defaultFontSize);
        }
        return this.add(newTxt);
    }

    public Paragraph add(Span content) {
        if (content == null) {
            return this;
        }
        this.contents.add(content);
        return this;
    }

    public Double getLineSpace() {
        return this.lineSpace;
    }

    public Paragraph setLineSpace(Double lineSpace) {
        this.lineSpace = lineSpace;
        return this;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Paragraph setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
        return this;
    }

    public Paragraph setDefaultFont(Font defaultFont, boolean refreshBeforeAdd) {
        this.defaultFont = defaultFont;
        if (refreshBeforeAdd) {
            this.contents.forEach(span -> span.setFont(defaultFont));
        }
        return this;
    }

    public Double getFontSize() {
        return this.defaultFontSize;
    }

    public Paragraph setFontSize(Double defaultFontSize) {
        this.defaultFontSize = defaultFontSize;
        return this;
    }

    public Paragraph setFontSize(Double defaultFontSize, boolean refreshBeforeAdd) {
        this.defaultFontSize = defaultFontSize;
        if (refreshBeforeAdd) {
            this.contents.forEach(span -> span.setFontSize(defaultFontSize));
        }
        return this;
    }

    public LinkedList<Span> getContents() {
        return this.contents;
    }

    public Paragraph setContents(List<Span> contents) {
        this.contents.clear();
        this.contents.addAll(contents);
        return this;
    }

    public LinkedList<TxtLineBlock> getLines() {
        return this.lines;
    }

    private TxtLineBlock newLine(double width) {
        return new TxtLineBlock(width, this.lineSpace, this.textAlign);
    }

    public Integer getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public Paragraph setFirstLineIndent(Integer firstLineIndent) {
        this.firstLineIndent = firstLineIndent;
        return this;
    }

    public Double getFirstLineIndentWidth() {
        return this.firstLineIndentWidth;
    }

    public Paragraph setFirstLineIndentWidth(double firstLineIndentWidth) {
        this.firstLineIndentWidth = firstLineIndentWidth;
        return this;
    }

    public Paragraph clearFirstLineIndent() {
        this.firstLineIndent = null;
        return this;
    }

    public Paragraph setTextAlign(TextAlign textAlign) {
        if (textAlign == null) {
            textAlign = TextAlign.left;
        }
        this.textAlign = textAlign;
        return this;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    private LinkedList<Span> spanLinebreakSplit(LinkedList<Span> seq) {
        LinkedList<Span> sps = new LinkedList<Span>();
        if (seq == null || seq.isEmpty()) {
            return sps;
        }
        while (!seq.isEmpty()) {
            Span pop = seq.pop();
            LinkedList<Span> spans = pop.splitLineBreak();
            sps.addAll(spans);
        }
        return sps;
    }

    private void processPlaceholder(LinkedList<Span> seq) {
        if (seq == null || seq.isEmpty()) {
            return;
        }
        if (!(this.firstLineIndent != null && this.firstLineIndent != 0 || this.firstLineIndentWidth != null && this.firstLineIndentWidth != 0.0)) {
            return;
        }
        Span firstSpan = seq.peek();
        if (firstSpan instanceof PlaceholderSpan) {
            PlaceholderSpan h = (PlaceholderSpan)firstSpan;
            if (h.getHoldWidth() == 0.0 && h.getHoldNum() == 0) {
                seq.pop();
            }
            if (this.firstLineIndentWidth != null && this.firstLineIndentWidth > 0.0) {
                h.setHoldWidth(this.firstLineIndentWidth);
            } else {
                h.setHoldChars(this.firstLineIndent);
            }
            return;
        }
        if (this.firstLineIndentWidth != null) {
            seq.push(new PlaceholderSpan(this.firstLineIndentWidth, (double)firstSpan.getFontSize()));
        } else {
            seq.push(new PlaceholderSpan((int)this.firstLineIndent, firstSpan));
        }
    }

    private void setHeightIfNotExist(double height) {
        if (this.getHeight() == null || this.getHeight() == 0.0) {
            this.setHeight(height);
        }
    }

    private void setWidthIfNotExist(double width) {
        if (this.getWidth() == null || this.getWidth() == 0.0) {
            this.setWidth(width);
        }
    }

    @Override
    public Rectangle doPrepare(Double widthLimit) {
        this.lines.clear();
        Double originW = this.getWidth();
        Double lineMaxAvailableWidth = this.getWidth();
        if (widthLimit == null) {
            throw new NullPointerException("widthLimit\u4e3a\u7a7a");
        }
        widthLimit = widthLimit - this.widthPlus();
        if (lineMaxAvailableWidth == null || lineMaxAvailableWidth > widthLimit) {
            lineMaxAvailableWidth = widthLimit;
        }
        TxtLineBlock line = this.newLine(lineMaxAvailableWidth);
        LinkedList<Span> seq = new LinkedList<Span>(this.contents);
        this.processPlaceholder(seq);
        seq = this.spanLinebreakSplit(seq);
        while (!seq.isEmpty()) {
            Span s = seq.pop();
            double blockWidth = s.blockSize().getWidth();
            if (blockWidth > lineMaxAvailableWidth && s.isIntegrity().booleanValue() || !s.isIntegrity().booleanValue() && lineMaxAvailableWidth < s.glyphList().get(0).getW()) continue;
            boolean added = line.tryAdd(s);
            if (added) {
                if (!s.hasLinebreak()) continue;
                this.lines.add(line);
                line = this.newLine(lineMaxAvailableWidth);
                continue;
            }
            if (s.isIntegrity().booleanValue()) {
                this.lines.add(line);
                line = this.newLine(lineMaxAvailableWidth);
                seq.push(s);
                continue;
            }
            Span toNextLineSpan = line.trySplitAdd(s);
            if (toNextLineSpan == null) {
                seq.push(s);
            } else {
                seq.push(toNextLineSpan);
            }
            this.lines.add(line);
            line = this.newLine(lineMaxAvailableWidth);
        }
        if (!line.isEmpty()) {
            this.lines.add(line);
        }
        double height = this.lines.stream().mapToDouble(TxtLineBlock::getHeight).sum();
        this.setHeightIfNotExist(height);
        if (originW == null) {
            double maxWidth = this.lines.stream().mapToDouble(TxtLineBlock::getWidth).max().getAsDouble();
            this.setWidth(maxWidth);
        } else {
            this.setWidth(Math.min(this.getWidth(), widthLimit));
        }
        return new Rectangle(this.getWidth() + this.widthPlus(), this.getHeight() + this.heightPlus());
    }

    private Paragraph setLines(LinkedList<TxtLineBlock> lines) {
        this.lines = lines;
        for (TxtLineBlock item : lines) {
            this.contents.addAll(item.getInlineSpans());
        }
        return this;
    }

    @Override
    public <T extends Div> Div[] contentSplitAdjust(double sHeight, T div1, T div2) {
        LinkedList<TxtLineBlock> seq2 = new LinkedList<TxtLineBlock>(this.lines);
        LinkedList<TxtLineBlock> seq1 = new LinkedList<TxtLineBlock>();
        double remainHeight = sHeight - this.getMarginTop() - this.getBorderTop() - this.getPaddingTop();
        while (!seq2.isEmpty()) {
            TxtLineBlock line = seq2.pop();
            if (remainHeight < line.getHeight()) {
                seq2.push(line);
                break;
            }
            seq1.add(line);
            remainHeight -= line.getHeight();
        }
        Paragraph p1 = (Paragraph)div1;
        Paragraph p2 = (Paragraph)div2;
        if (seq2.isEmpty()) {
            ((Paragraph)((Paragraph)p1.setLines(seq1).setMarginBottom(0.0)).setBorderBottom(0.0)).setPaddingBottom(0.0);
            ((Paragraph)((Paragraph)((Paragraph)p2.setHeight(0.0)).setMarginTop(0.0)).setBorderTop(0.0)).setPaddingTop(0.0);
            return new Div[]{p1, p2};
        }
        if (seq1.isEmpty()) {
            Div placeholder = Div.placeholder(this.getWidth() + this.widthPlus(), sHeight, this.getFloat());
            return new Div[]{placeholder, this};
        }
        ((Paragraph)((Paragraph)((Paragraph)p1.setLines(seq1).setMarginBottom(0.0)).setBorderBottom(0.0)).setPaddingBottom(0.0)).setHeight(sHeight);
        ((Paragraph)((Paragraph)((Paragraph)p2.setLines(seq2).setMarginTop(0.0)).setBorderTop(0.0)).setPaddingTop(0.0)).setHeight(seq2.stream().mapToDouble(TxtLineBlock::getHeight).sum());
        return new Div[]{p1, p2};
    }

    @Override
    public Paragraph clone() {
        Paragraph p = new Paragraph();
        p = this.copyTo(p);
        p.lineSpace = this.lineSpace;
        p.defaultFont = this.defaultFont;
        p.defaultFontSize = this.defaultFontSize;
        p.lines = new LinkedList();
        p.contents = new LinkedList();
        return p;
    }
}

