/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Element;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.pageDescription.clips.ClipAble;

public class TextCode
extends OFDElement
implements ClipAble {
    public TextCode(Element proxy) {
        super(proxy);
    }

    public TextCode() {
        super("TextCode");
    }

    public TextCode setContent(String content) {
        this.setText(content);
        return this;
    }

    public String getContent() {
        return this.getText();
    }

    public TextCode setCoordinate(Double x, Double y) {
        return this.setX(x).setY(y);
    }

    public TextCode setX(Double x) {
        if (x == null) {
            this.removeAttr("X");
            return this;
        }
        this.addAttribute("X", STBase.fmt(x));
        return this;
    }

    public Double getX() {
        String str = this.attributeValue("X");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return Double.parseDouble(str);
    }

    public TextCode setY(Double y) {
        if (y == null) {
            this.removeAttr("Y");
            return this;
        }
        this.addAttribute("Y", STBase.fmt(y));
        return this;
    }

    public Double getY() {
        String str = this.attributeValue("Y");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return Double.parseDouble(str);
    }

    public TextCode setDeltaX(ST_Array deltaX) {
        if (deltaX == null) {
            this.removeAttr("DeltaX");
            return this;
        }
        this.addAttribute("DeltaX", deltaX.toString());
        return this;
    }

    public TextCode setDeltaX(Double ... arr) {
        return this.setDeltaX(new ST_Array(arr));
    }

    public ST_Array getDeltaX() {
        String str = this.attributeValue("DeltaX");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return ST_Array.getInstance(this.deltaFormatter(str));
    }

    public TextCode setDeltaY(ST_Array deltaY) {
        if (deltaY == null) {
            this.removeAttr("DeltaY");
            return this;
        }
        this.addAttribute("DeltaY", deltaY.toString());
        return this;
    }

    public TextCode setDeltaY(Double ... arr) {
        return this.setDeltaY(new ST_Array(arr));
    }

    public ST_Array getDeltaY() {
        String str = this.attributeValue("DeltaY");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return ST_Array.getInstance(this.deltaFormatter(str));
    }

    private String deltaFormatter(String delta) {
        if (!delta.contains("g")) {
            return delta;
        }
        List tempList = Arrays.stream(delta.split(" ")).collect(Collectors.toList());
        boolean gFlag = false;
        boolean gProcessing = false;
        int gItemCount = 0;
        ArrayList<String> floatList = new ArrayList<String>();
        for (String s : tempList) {
            if ("g".equals(s)) {
                gFlag = true;
                continue;
            }
            if (s == null || s.trim().length() == 0) continue;
            if (gFlag) {
                gItemCount = Integer.parseInt(s);
                gProcessing = true;
                gFlag = false;
                continue;
            }
            if (gProcessing) {
                for (int j = 0; j < gItemCount; ++j) {
                    floatList.add(s);
                }
                gProcessing = false;
                continue;
            }
            floatList.add(s);
        }
        StringBuilder sb = new StringBuilder();
        for (String item : floatList) {
            sb.append(' ').append(item);
        }
        return sb.toString().trim();
    }
}

