/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.graph.pathObj;

import java.util.Arrays;
import java.util.List;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.core.graph.tight.method.Arc;
import org.ofdrw.core.graph.tight.method.Close;
import org.ofdrw.core.graph.tight.method.Command;
import org.ofdrw.core.graph.tight.method.CubicBezier;
import org.ofdrw.core.graph.tight.method.Line;
import org.ofdrw.core.graph.tight.method.Move;
import org.ofdrw.core.graph.tight.method.QuadraticBezier;

public class OptVal
implements Cloneable {
    public String opt;
    public double[] values = new double[0];

    public OptVal(String opt) {
        this.opt = opt;
    }

    public OptVal(String opt, double[] values) {
        this.opt = opt;
        if (values != null) {
            this.values = values;
        }
    }

    public OptVal(String opt, List<String> valueStrList) {
        this.opt = opt;
        if (valueStrList != null) {
            this.values = new double[valueStrList.size()];
            for (int i = 0; i < valueStrList.size(); ++i) {
                try {
                    this.values[i] = Double.parseDouble(valueStrList.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.values[i] = 0.0;
                }
            }
        }
    }

    public String getOpt() {
        return this.opt;
    }

    public void setOpt(String opt) {
        this.opt = opt;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public static double[] filling(double[] arr, int num) {
        if (arr == null) {
            arr = new double[num];
        }
        if (arr.length < num) {
            return Arrays.copyOf(arr, num);
        }
        return arr;
    }

    public Command toCmd() {
        switch (this.opt) {
            case "S": 
            case "M": {
                double[] arr = OptVal.filling(this.values, 2);
                return new Move(arr[0], arr[1]);
            }
            case "L": {
                double[] arr = OptVal.filling(this.values, 2);
                return new Line(arr[0], arr[1]);
            }
            case "Q": {
                double[] arr = OptVal.filling(this.values, 4);
                return new QuadraticBezier(arr[0], arr[1], arr[2], arr[3]);
            }
            case "B": {
                double[] arr = OptVal.filling(this.values, 6);
                return new CubicBezier(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
            }
            case "A": {
                double[] arr = OptVal.filling(this.values, 7);
                return new Arc(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6]);
            }
            case "C": {
                return new Close();
            }
        }
        return null;
    }

    public double[] expectValues() {
        switch (this.opt) {
            case "S": 
            case "M": 
            case "L": {
                return OptVal.filling(this.values, 2);
            }
            case "Q": {
                return OptVal.filling(this.values, 4);
            }
            case "B": {
                return OptVal.filling(this.values, 6);
            }
            case "A": {
                return OptVal.filling(this.values, 7);
            }
            case "C": {
                return new double[0];
            }
        }
        return new double[0];
    }

    public OptVal clone() {
        return new OptVal(this.opt, (double[])this.values.clone());
    }

    public String toString() {
        switch (this.opt) {
            case "S": 
            case "M": 
            case "L": {
                double[] arr = OptVal.filling(this.values, 2);
                return String.format("%s %s %s", this.opt, STBase.fmt(arr[0]), STBase.fmt(arr[1]));
            }
            case "Q": {
                double[] arr = OptVal.filling(this.values, 4);
                return String.format("Q %s %s %s %s", STBase.fmt(arr[0]), STBase.fmt(arr[1]), STBase.fmt(arr[2]), STBase.fmt(arr[3]));
            }
            case "B": {
                double[] arr = OptVal.filling(this.values, 6);
                return String.format("B %s %s %s %s %s %s", STBase.fmt(arr[0]), STBase.fmt(arr[1]), STBase.fmt(arr[2]), STBase.fmt(arr[3]), STBase.fmt(arr[4]), STBase.fmt(arr[5]));
            }
            case "A": {
                double[] arr = OptVal.filling(this.values, 7);
                return String.format("A %s %s %s %s %s %s %s", STBase.fmt(arr[0]), STBase.fmt(arr[1]), STBase.fmt(arr[2]), STBase.fmt(arr[3]), STBase.fmt(arr[4]), STBase.fmt(arr[5]), STBase.fmt(arr[6]));
            }
            case "C": {
                return "C";
            }
        }
        return "";
    }
}

