/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Lang;
import org.nutz.weixin.bean.WxMaster;
import org.nutz.weixin.impl.BasicWxHandler;
import org.nutz.weixin.impl.WxApiImpl;
import org.nutz.weixin.spi.WxAPI;
import org.nutz.weixin.spi.WxHandler;

@Deprecated
public class WxContext {
    public static final String DEF = "default";
    protected Map<String, WxMaster> masters = new HashMap<String, WxMaster>();
    protected Map<String, WxAPI> apis = new HashMap<String, WxAPI>();
    protected Map<String, WxHandler> handlers = new HashMap<String, WxHandler>();

    public WxAPI getAPI(String openid) {
        if (openid == null) {
            openid = DEF;
        }
        return this.apis.get(openid);
    }

    public WxMaster get(String openid) {
        if (openid == null) {
            openid = DEF;
        }
        return this.masters.get(openid);
    }

    public void setApis(Map<String, WxAPI> apis) {
        this.apis = apis;
    }

    public void setMasters(Map<String, WxMaster> masters) {
        this.masters = masters;
    }

    public void setPath(String path) {
        PropertiesProxy pp = new PropertiesProxy(new String[]{path});
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(pp.toMap());
        if (pp.get("openid") != null) {
            String appid = pp.get("openid");
            WxMaster def = (WxMaster)Lang.map2Object(map, WxMaster.class);
            this.masters.put(appid, def);
            this.apis.put(appid, new WxApiImpl(def));
            this.handlers.put(appid, new BasicWxHandler(def.getToken()));
        }
        for (Map.Entry en : map.entrySet()) {
            String key = (String)en.getKey();
            if (!key.endsWith(".openid")) continue;
            key = key.substring(0, key.indexOf(46));
            Map<String, Object> tmp = WxContext.filter(map, key + ".", null, null, null);
            String openid = tmp.get("openid").toString();
            WxMaster one = (WxMaster)Lang.map2Object(tmp, WxMaster.class);
            this.masters.put(openid, one);
            this.apis.put(openid, new WxApiImpl(one));
            this.handlers.put(openid, new BasicWxHandler(one.getToken()));
        }
    }

    public String export() {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, WxMaster> map = new LinkedHashMap<String, WxMaster>(this.masters);
        for (Map.Entry en : map.entrySet()) {
            String prefix = null;
            prefix = DEF.equals(en.getKey()) ? "" : (String)en.getKey() + ".";
            for (Map.Entry _en : Lang.obj2map(en.getValue()).entrySet()) {
                sb.append(prefix).append((String)_en.getKey()).append('=').append(_en.getValue()).append('\n');
            }
        }
        return sb.toString();
    }

    public static Map<String, Object> filter(Map<String, Object> source, String prefix, String include, String exclude, Map<String, String> keyMap) {
        LinkedHashMap<String, Object> dst = new LinkedHashMap<String, Object>();
        if (source == null || source.isEmpty()) {
            return dst;
        }
        Pattern includePattern = include == null ? null : Pattern.compile(include);
        Pattern excludePattern = exclude == null ? null : Pattern.compile(exclude);
        for (Map.Entry<String, Object> en : source.entrySet()) {
            String key = en.getKey();
            if (prefix != null) {
                if (!key.startsWith(prefix)) continue;
                key = key.substring(prefix.length());
            }
            if (includePattern != null && !includePattern.matcher(key).find() || excludePattern != null && excludePattern.matcher(key).find()) continue;
            if (keyMap != null && keyMap.containsKey(key)) {
                dst.put(keyMap.get(key), en.getValue());
                continue;
            }
            dst.put(key, en.getValue());
        }
        return dst;
    }

    public WxHandler getHandler(String openid) {
        return this.handlers.get(openid);
    }
}

