/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.session.memory;

import java.util.concurrent.ConcurrentHashMap;
import org.nutz.weixin.session.AbstractWxSessionManager;
import org.nutz.weixin.session.memory.MemoryWxSession;
import org.nutz.weixin.spi.WxSession;

public class MemorySessionManager
extends AbstractWxSessionManager {
    public static long DEF_TIMEOUT = 2880L;
    protected ConcurrentHashMap<String, MemoryWxSession> sessions = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxSession getSession(String id, boolean create) {
        String sessionId = id;
        MemoryWxSession session = this.sessions.get(sessionId);
        if (session != null) {
            int maxInterval = session.getMaxInactiveInterval();
            if (maxInterval < 1) {
                return session;
            }
            long interval = (System.currentTimeMillis() - session.getLastAccessedTime()) / 1000L / 60L;
            if ((long)maxInterval > interval) {
                session.setLastAccessedTime(System.currentTimeMillis());
                return session;
            }
            session = null;
        }
        ConcurrentHashMap<String, MemoryWxSession> concurrentHashMap = this.sessions;
        synchronized (concurrentHashMap) {
            session = this.sessions.get(sessionId);
            if (session == null) {
                session = new MemoryWxSession(sessionId, this);
                session.setCreateTime(System.currentTimeMillis());
                session.setLastAccessedTime(System.currentTimeMillis());
                this.sessions.put(sessionId, session);
                return session;
            }
        }
        return session;
    }

    void remove(String id) {
        this.sessions.remove(id);
    }
}

