/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.weixin.impl;

import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Strings;
import org.nutz.weixin.impl.AbstractWxHandler;
import org.nutz.weixin.repo.com.qq.weixin.mp.aes.AesException;
import org.nutz.weixin.repo.com.qq.weixin.mp.aes.WXBizMsgCrypt;
import org.nutz.weixin.util.Wxs;

public class BasicWxHandler
extends AbstractWxHandler {
    protected String token;
    protected String aeskey;
    protected WXBizMsgCrypt msgCrypt;
    protected String appid;

    protected BasicWxHandler() {
    }

    public BasicWxHandler(String token) {
        this.token = token;
    }

    public BasicWxHandler(String token, String aeskey, String appid) {
        this.token = token;
        this.aeskey = aeskey;
        this.appid = appid;
    }

    @Override
    public boolean check(String signature, String timestamp, String nonce, String key) {
        return Wxs.check(this.token, signature, timestamp, nonce);
    }

    @Override
    public WXBizMsgCrypt getMsgCrypt() {
        if (this.msgCrypt == null) {
            try {
                this.msgCrypt = new WXBizMsgCrypt(this.token, this.aeskey, this.appid);
            }
            catch (AesException e) {
                throw new RuntimeException(e);
            }
        }
        return this.msgCrypt;
    }

    public void configure(PropertiesProxy conf, String prefix) {
        prefix = Strings.sBlank((Object)prefix);
        this.token = conf.check(prefix + "token");
        this.aeskey = conf.get(prefix + "aes");
        this.appid = conf.get(prefix + "appid");
    }
}

