/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.velocity;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.view.ServletUtils;
import org.apache.velocity.tools.view.VelocityView;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.config.FilterNutConfig;
import org.nutz.mvc.config.ServletNutConfig;
import org.nutz.mvc.view.AbstractPathView;

public class VelocityLayoutView
extends AbstractPathView {
    private static final Log log = Logs.get();
    private VelocityView view;
    private String defaultLayout;
    private String layoutDir;
    private String vmPath;
    private boolean bufferOutput = false;
    private String errorTemplate;

    public VelocityLayoutView(String dest) {
        super(dest);
    }

    public void init() {
        PropertiesProxy propertiesProxy = new PropertiesProxy(new String[]{Mvcs.getNutConfig().getInitParameter("org.apache.velocity.properties")});
        this.errorTemplate = propertiesProxy.get("tools.view.servlet.error.template", "Error.vm").trim();
        this.layoutDir = propertiesProxy.get("tools.view.servlet.layout.directory", "layout/").trim();
        this.defaultLayout = propertiesProxy.get("tools.view.servlet.layout.default.template", "Default.vm").trim();
        if (!this.layoutDir.endsWith("/")) {
            this.layoutDir = this.layoutDir + '/';
        }
        this.defaultLayout = this.layoutDir + this.defaultLayout;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Object obj) throws Throwable {
        this.init();
        this.vmPath = this.evalPath(request, obj);
        Context context = null;
        try {
            context = this.createContext(request, response);
            this.fillContext(context, request);
            this.setContentType(request, response);
            Template template = this.handleRequest(request, response, context);
            this.mergeTemplate(template, context, response);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ResourceNotFoundException e) {
            this.manageResourceNotFound(request, response, e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.requestCleanup(request, response, context);
        }
    }

    private void requestCleanup(HttpServletRequest request, HttpServletResponse response, Context context) {
    }

    protected void manageResourceNotFound(HttpServletRequest request, HttpServletResponse response, ResourceNotFoundException e) throws IOException {
        String path = ServletUtils.getPath((HttpServletRequest)request);
        log.debug((Object)("Resource not found for path '" + path + "'"), (Throwable)e);
        String message = e.getMessage();
        if (response.isCommitted() || path == null || message == null || !message.contains("'" + path + "'")) {
            this.error(request, response, e);
            throw e;
        }
        response.sendError(404, path);
    }

    private void error(HttpServletRequest request, HttpServletResponse response, ResourceNotFoundException ex) {
        try {
            Context ctx = this.createContext(request, response);
            Throwable cause = ex;
            if (cause instanceof MethodInvocationException) {
                ctx.put("invocation_exception", (Object)ex);
                cause = ex.getWrappedThrowable();
            }
            ctx.put("error_cause", (Object)cause);
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            ctx.put("stack_trace", (Object)sw.toString());
            Template et = this.getTemplate(this.errorTemplate);
            this.mergeTemplate(et, ctx, response);
        }
        catch (Exception e) {
            log.error((Object)"Error during error template rendering", (Throwable)e);
            if (!response.isCommitted()) {
                return;
            }
            try {
                String path = ServletUtils.getPath((HttpServletRequest)request);
                log.error((Object)("Error processing a template for path '" + path + "'"), (Throwable)e);
                StringBuilder html = new StringBuilder();
                html.append("<html>\n");
                html.append("<head><title>Error</title></head>\n");
                html.append("<body>\n");
                html.append("<h2>VelocityView : Error processing a template for path '");
                html.append(path);
                html.append("'</h2>\n");
                Throwable cause = e;
                String why = cause.getMessage();
                if (why != null && why.length() > 0) {
                    html.append(StringEscapeUtils.escapeHtml((String)why));
                    html.append("\n<br>\n");
                }
                if (cause instanceof MethodInvocationException) {
                    cause = ((MethodInvocationException)cause).getWrappedThrowable();
                }
                StringWriter sw = new StringWriter();
                cause.printStackTrace(new PrintWriter(sw));
                html.append("<pre>\n");
                html.append(StringEscapeUtils.escapeHtml((String)sw.toString()));
                html.append("</pre>\n");
                html.append("</body>\n");
                html.append("</html>");
                response.getWriter().write(html.toString());
            }
            catch (Exception e2) {
                String msg = "Exception while printing error screen";
                log.error((Object)msg, (Throwable)e2);
                throw new RuntimeException(msg, e);
            }
        }
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws IOException {
        block3: {
            StringWriter sw = new StringWriter();
            template.merge(context, (Writer)sw);
            context.put("screen_content", (Object)sw.toString());
            Object obj = context.get("layout");
            String layout = obj == null ? null : obj.toString();
            layout = layout == null ? this.defaultLayout : this.layoutDir + layout;
            try {
                template = this.getTemplate(layout);
            }
            catch (Exception e) {
                log.error((Object)("Can't load layout \"" + layout + "\""), (Throwable)e);
                if (layout.equals(this.defaultLayout)) break block3;
                template = this.getTemplate(this.defaultLayout);
            }
        }
        Writer writer = this.bufferOutput ? new StringWriter() : response.getWriter();
        this.getVelocityView().merge(template, context, writer);
        if (this.bufferOutput) {
            response.getWriter().write(writer.toString());
        }
    }

    protected Template getTemplate(String name) {
        return this.getVelocityView().getTemplate(name);
    }

    private Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) {
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            context.put(attr, request.getAttribute(attr));
        }
        return this.getVelocityView().getTemplate(this.vmPath);
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getVelocityView().getDefaultContentType());
    }

    protected void fillContext(Context ctx, HttpServletRequest request) {
        String layout = this.findLayout(request);
        if (layout != null) {
            ctx.put("layout", (Object)layout);
        }
    }

    protected String findLayout(HttpServletRequest request) {
        String layout = request.getParameter("layout");
        if (layout == null) {
            layout = (String)request.getAttribute("layout");
        }
        return layout;
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        return this.getVelocityView().createContext(request, response);
    }

    protected VelocityView getVelocityView() {
        if (this.view == null) {
            try {
                Object config_ = this.getConfig();
                if (config_ instanceof FilterConfig) {
                    this.setVelocityView(ServletUtils.getVelocityView((FilterConfig)((FilterConfig)config_)));
                } else {
                    this.setVelocityView(ServletUtils.getVelocityView((ServletConfig)((ServletConfig)config_)));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            assert (this.view != null);
        }
        return this.view;
    }

    protected Object getConfig() throws IllegalArgumentException, IllegalAccessException {
        NutConfig config = Mvcs.getNutConfig();
        if (config instanceof FilterNutConfig) {
            FilterNutConfig con = (FilterNutConfig)Mvcs.getNutConfig();
            for (Field f : con.getClass().getDeclaredFields()) {
                if (!Strings.equalsIgnoreCase((String)"config", (String)f.getName())) continue;
                f.setAccessible(true);
                return f.get(con);
            }
        } else {
            ServletNutConfig con = (ServletNutConfig)Mvcs.getNutConfig();
            for (Field f : con.getClass().getDeclaredFields()) {
                if (!Strings.equalsIgnoreCase((String)"config", (String)f.getName())) continue;
                f.setAccessible(true);
                return f.get(con);
            }
        }
        return null;
    }

    private void setVelocityView(VelocityView velocityView) {
        this.view = velocityView;
    }
}

