/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.thymeleaf;

import java.io.Writer;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.view.AbstractPathView;
import org.nutz.plugins.view.thymeleaf.ThymeleafProperties;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

public class ThymeleafView
extends AbstractPathView {
    private static final Log log = Logs.get();
    private ThymeleafProperties properties;

    public ThymeleafView(ThymeleafProperties properties, String path) {
        super(path);
        this.properties = properties;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Object value) throws Exception {
        String path = this.evalPath(request, value);
        response.setContentType(this.properties.getContentType() + "; charset=" + this.properties.getEncoding());
        response.setCharacterEncoding(this.properties.getEncoding());
        try {
            Context ctx = AbstractPathView.createContext((HttpServletRequest)request, (Object)value);
            WebContext context = new WebContext(request, response, Mvcs.getServletContext(), Locale.getDefault(), ctx.getInnerMap());
            TemplateEngine templateEngine = new TemplateEngine();
            templateEngine.setTemplateResolver(this.initializeTemplateResolver(this.properties));
            templateEngine.addDialect((IDialect)new LayoutDialect());
            IDialect[] dialects = this.properties.getDialects();
            if (null != dialects) {
                for (IDialect dialect : dialects) {
                    templateEngine.addDialect(dialect);
                }
            }
            templateEngine.process(path, (IContext)context, (Writer)response.getWriter());
        }
        catch (Exception e) {
            log.error((Object)"\u6a21\u677f\u5f15\u64ce\u9519\u8bef", (Throwable)e);
            throw e;
        }
    }

    private ITemplateResolver initializeTemplateResolver(ThymeleafProperties properties) {
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver(Mvcs.getServletContext());
        templateResolver.setTemplateMode(properties.getMode());
        templateResolver.setPrefix(properties.getPrefix());
        templateResolver.setSuffix(properties.getSuffix());
        templateResolver.setCharacterEncoding(properties.getEncoding());
        templateResolver.setCacheable(properties.isCache());
        templateResolver.setCacheTTLMs(properties.getCacheTTLMs());
        return templateResolver;
    }
}

