/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.pdf;

import com.google.typography.font.tools.sfnttool.SfntTool;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.View;
import org.nutz.plugins.view.pdf.PdfViewFormat;

public class PdfView
implements View {
    private static final Log log;
    protected static byte[] defaultFontData;
    public static BaseFont DEFAULT_FONT;
    protected PdfViewFormat format;

    public static void setDefaultFontData(byte[] defaultFontData) {
        PdfView.defaultFontData = defaultFontData;
    }

    public static void setDefaultFontPath(String path) {
        defaultFontData = (byte[])(path == null ? null : Files.readBytes((String)path));
    }

    public PdfView(String value) {
        if (Strings.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("pdf view need template file path");
        }
        this.format = new PdfViewFormat();
        this.format.tmpl = value;
    }

    public PdfView(PdfViewFormat format) {
        this.format = format;
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Throwable {
        File f = Files.findFile((String)this.format.tmpl);
        if (!f.exists()) {
            resp.sendError(404);
            return;
        }
        Context cnt = (Context)obj;
        resp.setContentType("application/pdf");
        if (!resp.containsHeader("Content-Disposition") && !cnt.getBoolean("*viewOnly")) {
            String filename = URLEncoder.encode(cnt.getString("filename", "out.pdf"), "UTF-8");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        PdfReader reader = new PdfReader(Streams.fileIn((File)f));
        ServletOutputStream out = resp.getOutputStream();
        PdfStamper ps = new PdfStamper(reader, (OutputStream)out);
        AcroFields fields = ps.getAcroFields();
        StringBuilder sb = new StringBuilder();
        for (Object key : fields.getFields().keySet()) {
            sb.append(Strings.sBlank((Object)cnt.get((String)key)));
        }
        BaseFont bf = PdfView.subFont(this.format.fontData, sb.toString());
        for (String key : fields.getFields().keySet()) {
            fields.setField(key, Strings.sBlank((Object)cnt.get(key)));
            if (bf == null) continue;
            fields.setFieldProperty(key, "textfont", (Object)bf, null);
        }
        ps.setFormFlattening(true);
        Callback callback = (Callback)cnt.getAs(Callback.class, "*callback");
        if (callback != null) {
            callback.invoke((Object)ps);
        }
        ps.close();
    }

    public static BaseFont subFont(byte[] source, String strs) {
        if (source == null) {
            source = defaultFontData;
        }
        if (source == null) {
            return null;
        }
        try {
            byte[] buf = SfntTool.sub((byte[])source, (String)strs, (boolean)false);
            return BaseFont.createFont((String)("pdfview." + R.UU32() + ".ttf"), (String)"Identity-H", (boolean)true, (boolean)false, (byte[])buf, null);
        }
        catch (Exception e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    static {
        String[] paths;
        log = Logs.get();
        for (String path : paths = new String[]{"fonts/pdf.ttc", "fonts/pdf.ttf", "C:\\windows\\fonts\\msyhl.ttc", "/usr/share/fonts/msyhl.ttc", "/System/Library/Fonts/msyhl.ttc"}) {
            try {
                if (!new File(path).exists()) continue;
                PdfView.setDefaultFontPath(path);
                log.debug((Object)"\u5fae\u8f6f\u96c5\u9ed1Light found");
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

