/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.freemarker;

import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.view.AbstractPathView;
import org.nutz.plugins.view.freemarker.FreeMarkerConfigurer;
import org.nutz.plugins.view.freemarker.JspSupportServlet;

public class FreemarkerView
extends AbstractPathView {
    private FreeMarkerConfigurer freeMarkerConfigurer;
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String ATTR_JSP_TAGLIBS_MODEL = ".freemarker.JspTaglibs";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    private static final String ATTR_REQUEST_PARAMETERS_MODEL = ".freemarker.RequestParameters";
    private static final String KEY_APPLICATION = "Application";
    private static final String KEY_REQUEST_MODEL = "Request";
    private static final String KEY_SESSION_MODEL = "Session";
    private static final String KEY_REQUEST_PARAMETER_MODEL = "Parameters";
    private static final String KEY_EXCEPTION = "exception";
    private static final String OBJ = "obj";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    private static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    public static final String PATH_BASE = "base";

    public FreemarkerView(FreeMarkerConfigurer freeMarkerConfigurer, String path) {
        super(path);
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Object value) throws Throwable {
        String $temp = this.evalPath(request, value);
        String path = this.getPath($temp);
        ServletContext sc = request.getSession().getServletContext();
        Configuration cfg = this.freeMarkerConfigurer.getConfiguration();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put(OBJ, value);
        root.put(REQUEST, request);
        root.put(RESPONSE, response);
        HttpSession session = request.getSession();
        root.put(SESSION, session);
        root.put(APPLICATION, sc);
        root.put("props", System.getProperties());
        Map msgs = Mvcs.getMessages((ServletRequest)request);
        root.put("mvcs", msgs);
        Enumeration reqs = request.getAttributeNames();
        while (reqs.hasMoreElements()) {
            String strKey = (String)reqs.nextElement();
            root.put(strKey, request.getAttribute(strKey));
        }
        this.jspTaglibs(sc, request, response, root, cfg.getObjectWrapper());
        try {
            Template template = cfg.getTemplate(path);
            response.setContentType("text/html; charset=" + template.getEncoding());
            template.process(root, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    protected String getExt() {
        return this.freeMarkerConfigurer.getSuffix();
    }

    private String getPath(String path) {
        StringBuffer sb = new StringBuffer();
        if (Strings.isBlank((CharSequence)path)) {
            sb.append(Mvcs.getServletContext().getRealPath(this.freeMarkerConfigurer.getPrefix()));
            sb.append(path.startsWith("/") ? "" : "/");
            sb.append(Files.renameSuffix((String)path, (String)this.getExt()));
        } else if (path.charAt(0) == '/') {
            String ext = this.getExt();
            sb.append(path);
            if (!path.toLowerCase().endsWith(ext)) {
                sb.append(ext);
            }
        } else {
            sb.append(path.replace('.', '/'));
            sb.append(this.getExt());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jspTaglibs(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Map<String, Object> model, ObjectWrapper wrapper) {
        HttpRequestHashModel requestModel;
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            JspSupportServlet servlet;
            ServletContextHashModel servletContextModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
            if (Lang.isEmpty((Object)servletContextModel) && !Lang.isEmpty((Object)((Object)(servlet = JspSupportServlet.jspSupportServlet)))) {
                servletContextModel = new ServletContextHashModel((GenericServlet)servlet, wrapper);
                servletContext.setAttribute(ATTR_APPLICATION_MODEL, (Object)servletContextModel);
                TaglibFactory taglibs = new TaglibFactory(servletContext);
                servletContext.setAttribute(ATTR_JSP_TAGLIBS_MODEL, (Object)taglibs);
            }
            model.put(KEY_APPLICATION, servletContextModel);
            TemplateModel tempModel = (TemplateModel)servletContext.getAttribute(ATTR_JSP_TAGLIBS_MODEL);
            model.put(KEY_JSP_TAGLIBS, tempModel);
        }
        HttpSession session = request.getSession(false);
        if (!Lang.isEmpty((Object)session)) {
            model.put(KEY_SESSION_MODEL, new HttpSessionHashModel(session, wrapper));
        }
        if (Lang.isEmpty((Object)(requestModel = (HttpRequestHashModel)request.getAttribute(ATTR_REQUEST_MODEL))) || !Lang.equals((Object)requestModel.getRequest(), (Object)request)) {
            requestModel = new HttpRequestHashModel(request, response, wrapper);
            request.setAttribute(ATTR_REQUEST_MODEL, (Object)requestModel);
        }
        model.put(KEY_REQUEST_MODEL, requestModel);
        HttpRequestParametersHashModel reqParametersModel = (HttpRequestParametersHashModel)request.getAttribute(ATTR_REQUEST_PARAMETERS_MODEL);
        if (Lang.isEmpty((Object)reqParametersModel) || !Lang.equals((Object)requestModel.getRequest(), (Object)request)) {
            reqParametersModel = new HttpRequestParametersHashModel(request);
            request.setAttribute(ATTR_REQUEST_PARAMETERS_MODEL, (Object)reqParametersModel);
        }
        model.put(KEY_REQUEST_PARAMETER_MODEL, reqParametersModel);
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (Lang.isEmpty((Object)exception)) {
            exception = (Throwable)request.getAttribute("javax.servlet.error.JspException");
        }
        if (!Lang.isEmpty((Object)exception)) {
            model.put(KEY_EXCEPTION, exception);
        }
    }
}

