/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.freemarker;

import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.plugins.view.freemarker.FreemarkerDirective;
import org.nutz.plugins.view.freemarker.FreemarkerDirectiveFactory;

public class FreeMarkerConfigurer {
    private static final Log log = Logs.get();
    private static final String NEW_LINE = "\r\n";
    private Configuration configuration;
    private String prefix;
    private String suffix;
    private FreemarkerDirectiveFactory freemarkerDirectiveFactory;
    private Map<String, Object> tags = new HashMap<String, Object>();
    private final StringBuilder pro = new StringBuilder();

    public FreeMarkerConfigurer() {
        Configuration configuration = new Configuration();
        this.initp(configuration, Mvcs.getServletContext(), "WEB-INF", ".ftl", new FreemarkerDirectiveFactory());
    }

    public FreeMarkerConfigurer(Configuration configuration, ServletContext sc, String prefix, String suffix, FreemarkerDirectiveFactory freemarkerDirectiveFactory) {
        this.initp(configuration, sc, prefix, suffix, freemarkerDirectiveFactory);
    }

    protected void initp(Configuration configuration, ServletContext sc, String prefix, String suffix, FreemarkerDirectiveFactory freemarkerDirectiveFactory) {
        this.configuration = configuration;
        this.prefix = sc.getRealPath(prefix);
        this.suffix = suffix;
        this.freemarkerDirectiveFactory = freemarkerDirectiveFactory;
        if (this.prefix == null) {
            this.prefix = sc.getRealPath("/") + prefix;
        }
        this.pro.append("tag_syntax=auto_detect").append(NEW_LINE);
        this.pro.append("template_update_delay=-1").append(NEW_LINE);
        this.pro.append("defaultEncoding=UTF-8").append(NEW_LINE);
        this.pro.append("url_escaping_charset=UTF-8").append(NEW_LINE);
        this.pro.append("locale=zh_CN").append(NEW_LINE);
        this.pro.append("boolean_format=true,false").append(NEW_LINE);
        this.pro.append("datetime_format=yyyy-MM-dd HH:mm:ss").append(NEW_LINE);
        this.pro.append("date_format=yyyy-MM-dd").append(NEW_LINE);
        this.pro.append("time_format=HH:mm:ss").append(NEW_LINE);
        this.pro.append("number_format=0.######").append(NEW_LINE);
        this.pro.append("whitespace_stripping=true");
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        try {
            this.initFreeMarkerConfigurer();
            for (Map.Entry<String, Object> entry : this.tags.entrySet()) {
                this.configuration.setSharedVariable(entry.getKey(), entry.getValue());
            }
            if (this.freemarkerDirectiveFactory == null) {
                return;
            }
            for (FreemarkerDirective freemarkerDirective : this.freemarkerDirectiveFactory.getList()) {
                this.configuration.setSharedVariable(freemarkerDirective.getName(), (TemplateModel)freemarkerDirective.getTemplateDirectiveModel());
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        catch (TemplateException e) {
            log.error((Object)e);
        }
    }

    public String getSuffix() {
        return Strings.isBlank((CharSequence)this.freemarkerDirectiveFactory.getSuffix()) ? this.suffix : this.freemarkerDirectiveFactory.getSuffix();
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected void initFreeMarkerConfigurer() throws IOException, TemplateException {
        Properties p = new Properties();
        String path = this.freemarkerDirectiveFactory.getFreemarker();
        File file = Files.findFile((String)path);
        if (Lang.isEmpty((Object)file)) {
            p.load(Streams.wrap((byte[])this.pro.toString().getBytes()));
        } else {
            p.load(Streams.fileIn((File)file));
        }
        this.configuration.setSettings(p);
        File f = Files.findFile((String)this.prefix);
        this.configuration.setDirectoryForTemplateLoading(f);
    }

    public void setTags(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            this.tags.put(key, obj);
        }
    }

    public FreeMarkerConfigurer setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public FreeMarkerConfigurer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public FreeMarkerConfigurer addTags(Map<String, Object> map) {
        if (map != null) {
            try {
                this.configuration.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(map));
            }
            catch (TemplateModelException e) {
                log.error((Object)e);
            }
        }
        return this;
    }
}

