/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.captcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.nutz.plugins.view.captcha.CaptchaGener;
import org.nutz.plugins.view.captcha.DefaultCaptchaGener;

public class ImageVerification {
    private int IMAGE_VERIFICATION_LENGTH = 4;
    private String verifyCode = "";
    private CaptchaGener captchaGener = new DefaultCaptchaGener();

    public void setIMAGE_VERIFICATION_LENGTH(int iMAGE_VERIFICATION_LENGTH) {
        this.IMAGE_VERIFICATION_LENGTH = iMAGE_VERIFICATION_LENGTH;
    }

    public BufferedImage creatImage() {
        int i;
        int width = 20 * this.IMAGE_VERIFICATION_LENGTH + 20;
        int height = 35;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Comic Sans MS", 1, 25));
        for (i = 0; i < 255; ++i) {
            g.setColor(this.getRandColor(140, 255));
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(100);
            int yl = random.nextInt(100);
            g.drawLine(x, y, x + xl, y + yl);
        }
        this.verifyCode = this.captchaGener.gen(this.IMAGE_VERIFICATION_LENGTH);
        for (i = 0; i < this.IMAGE_VERIFICATION_LENGTH; ++i) {
            String rand = this.verifyCode.charAt(i) + "";
            g.setColor(this.getRandColor(20, 130));
            g.drawString(rand, 20 * i + 10, 25 + this.getRandInt(-5, 5));
        }
        g.dispose();
        return image;
    }

    public Color getRandColor(int b, int e) {
        if (b > 255) {
            b = 255;
        }
        if (e > 255) {
            e = 255;
        }
        int rc = this.getRandInt(b, e);
        int gc = this.getRandInt(b, e);
        int bc = this.getRandInt(b, e);
        return new Color(rc, gc, bc);
    }

    public int getRandInt(int b, int e) {
        if (b > e) {
            int temp = e;
            e = b;
            b = temp;
        }
        Random random = new Random();
        return b + random.nextInt(e - b);
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public void setCaptchaGener(CaptchaGener captchaGener) {
        this.captchaGener = captchaGener;
    }
}

