/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view.captcha;

import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.View;
import org.nutz.plugins.view.captcha.CaptchaGener;
import org.nutz.plugins.view.captcha.ImageVerification;

public class CaptchaView
implements View {
    public static final String CAPTCHA = "KERBORES_NUTZ_CAPTCHA";
    private static final Log log = Logs.getLog(CaptchaView.class);
    private String contentType;
    private int length;
    private CaptchaGener captchaGener;

    public CaptchaView(String contentType) {
        this.contentType = contentType == null ? "image/jpeg" : contentType;
    }

    public CaptchaView(String contentType, int length) {
        this.contentType = contentType == null ? "image/jpeg" : contentType;
        this.length = length;
    }

    public CaptchaView(String contentType, CaptchaGener captchaGener) {
        this.contentType = contentType == null ? "image/jpeg" : contentType;
        this.captchaGener = captchaGener;
    }

    public CaptchaView(String contentType, CaptchaGener captchaGener, int length) {
        this.contentType = contentType == null ? "image/jpeg" : contentType;
        this.captchaGener = captchaGener;
        this.length = length;
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Throwable {
        resp.setContentType(this.contentType);
        resp.setHeader("Pragma", "No-cache");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setDateHeader("Expires", 0L);
        HttpSession session = req.getSession();
        ServletOutputStream out = resp.getOutputStream();
        ImageVerification iv = new ImageVerification();
        if (this.length != 0) {
            iv.setIMAGE_VERIFICATION_LENGTH(this.length);
        }
        if (this.captchaGener != null) {
            iv.setCaptchaGener(this.captchaGener);
        }
        if (ImageIO.write((RenderedImage)iv.creatImage(), "JPEG", (OutputStream)out)) {
            log.debugf("\u5199\u5165\u8f93\u51fa\u6d41\u6210\u529f:%s.", new Object[]{iv.getVerifyCode()});
        } else {
            log.debugf("\u5199\u5165\u8f93\u51fa\u6d41\u5931\u8d25:%s.", new Object[]{iv.getVerifyCode()});
        }
        session.setAttribute(CAPTCHA, (Object)iv.getVerifyCode());
        out.flush();
        out.close();
    }
}

