/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.View;
import org.nutz.mvc.impl.processor.ViewProcessor;
import org.nutz.mvc.view.VoidView;

public class MapView
implements View {
    protected Map<String, View> map;
    protected View defaultView;

    public MapView(NutConfig conf, ActionInfo ai, String _type, String _value) {
        if (Strings.isBlank((CharSequence)_value)) {
            this.map = Collections.EMPTY_MAP;
            this.defaultView = new VoidView();
        } else {
            Map mapping = Json.fromJsonAsMap(String.class, (CharSequence)_value);
            this.map = new HashMap<String, View>(mapping.size());
            for (Map.Entry entry : mapping.entrySet()) {
                View view = ViewProcessor.evalView((NutConfig)conf, (ActionInfo)ai, (String)((String)entry.getValue()));
                this.map.put((String)entry.getKey(), view);
            }
            this.defaultView = this.map.get("null");
            if (this.defaultView == null) {
                this.defaultView = this.map.get("default");
            }
            if (this.defaultView == null) {
                this.defaultView = new VoidView();
            }
        }
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Throwable {
        View view;
        if (null != obj && (view = this.map.get(String.valueOf(obj))) != null) {
            view.render(req, resp, obj);
            return;
        }
        this.defaultView.render(req, resp, obj);
    }
}

