/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.SimpleGlyph;

public class GlyphStripper {
    private final GlyphTable.Builder glyphTableBuilder;

    public GlyphStripper(GlyphTable.Builder glyphTableBuilder) {
        this.glyphTableBuilder = glyphTableBuilder;
    }

    public Glyph.Builder<? extends Glyph> stripGlyph(Glyph glyph) {
        WritableFontData newGlyphData = null;
        if (glyph != null && glyph.readFontData().length() > 0) {
            switch (glyph.glyphType()) {
                case Simple: {
                    newGlyphData = this.stripSimpleGlyph(glyph);
                    break;
                }
                case Composite: {
                    newGlyphData = this.stripCompositeGlyph(glyph);
                    break;
                }
            }
        }
        if (newGlyphData == null) {
            newGlyphData = WritableFontData.createWritableFontData(0);
        }
        return this.glyphTableBuilder.glyphBuilder(newGlyphData);
    }

    private WritableFontData stripSimpleGlyph(Glyph glyph) {
        int size = this.computeSimpleStrippedGlyphSize(glyph);
        int paddedSize = size + 1 & 0xFFFFFFFE;
        WritableFontData newGlyf = WritableFontData.createWritableFontData(paddedSize);
        SimpleGlyph simpleGlyph = (SimpleGlyph)glyph;
        ReadableFontData originalGlyfData = glyph.readFontData();
        int dataWritten = this.writeHeaderAndContoursSize(newGlyf, 0, originalGlyfData, 0, simpleGlyph);
        dataWritten += this.writeZeroInstructionLength(newGlyf, dataWritten);
        dataWritten += this.writeEndSimpleGlyph(newGlyf, dataWritten, originalGlyfData, dataWritten + simpleGlyph.instructionSize() * FontData.DataSize.BYTE.size(), size - dataWritten);
        return newGlyf;
    }

    private int writeHeaderAndContoursSize(WritableFontData newGlyf, int newGlyfOffset, ReadableFontData originalGlyfData, int glyphOffset, SimpleGlyph simpleGlyph) {
        int headerAndNumberOfContoursSize = FontData.DataSize.SHORT.size() * 5 + simpleGlyph.numberOfContours() * FontData.DataSize.USHORT.size();
        WritableFontData newGlyfSlice = newGlyf.slice(newGlyfOffset, headerAndNumberOfContoursSize);
        originalGlyfData.slice(glyphOffset, headerAndNumberOfContoursSize).copyTo(newGlyfSlice);
        return headerAndNumberOfContoursSize;
    }

    private int writeZeroInstructionLength(WritableFontData newGlyf, int offset) {
        newGlyf.writeUShort(offset, 0);
        return FontData.DataSize.USHORT.size();
    }

    private int writeEndSimpleGlyph(WritableFontData newGlyf, int newGlyfOffset, ReadableFontData originalGlyfData, int glyphOffset, int length) {
        ReadableFontData originalGlyfSlice = originalGlyfData.slice(glyphOffset, length);
        WritableFontData newGlyfSlice = newGlyf.slice(newGlyfOffset, length);
        originalGlyfSlice.copyTo(newGlyfSlice);
        return length;
    }

    private WritableFontData stripCompositeGlyph(Glyph glyph) {
        int dataLength = this.computeCompositeStrippedGlyphSize(glyph);
        WritableFontData newGlyf = WritableFontData.createWritableFontData(dataLength);
        CompositeGlyph compositeGlyph = (CompositeGlyph)glyph;
        ReadableFontData originalGlyphSlice = glyph.readFontData().slice(0, dataLength);
        originalGlyphSlice.copyTo(newGlyf);
        if (compositeGlyph.instructionSize() > 0) {
            this.overrideCompositeGlyfFlags(newGlyf, dataLength);
        }
        return newGlyf;
    }

    private void overrideCompositeGlyfFlags(WritableFontData slice, int dataLength) {
        int index = 5 * FontData.DataSize.USHORT.size();
        int flags = 32;
        while ((flags & 0x20) != 0) {
            flags = slice.readUShort(index);
            slice.writeUShort(index, flags &= 0xFFFFFEFF);
            index += 2 * FontData.DataSize.USHORT.size();
            index = (flags & 1) != 0 ? (index += 2 * FontData.DataSize.SHORT.size()) : (index += 2 * FontData.DataSize.BYTE.size());
            if ((flags & 8) != 0) {
                index += FontData.DataSize.F2DOT14.size();
                continue;
            }
            if ((flags & 0x40) != 0) {
                index += 2 * FontData.DataSize.F2DOT14.size();
                continue;
            }
            if ((flags & 0x80) == 0) continue;
            index += 4 * FontData.DataSize.F2DOT14.size();
        }
    }

    private int computeSimpleStrippedGlyphSize(Glyph glyph) {
        SimpleGlyph simpleGlyph = (SimpleGlyph)glyph;
        int instructionSize = simpleGlyph.instructionSize();
        int nonPaddedSimpleGlyphLength = simpleGlyph.dataLength() - simpleGlyph.padding();
        if (instructionSize > 0) {
            return nonPaddedSimpleGlyphLength - this.computeInstructionsSize(simpleGlyph);
        }
        return nonPaddedSimpleGlyphLength;
    }

    private int computeInstructionsSize(SimpleGlyph simpleGlyph) {
        return simpleGlyph.instructionSize() * FontData.DataSize.BYTE.size();
    }

    private int computeCompositeStrippedGlyphSize(Glyph glyph) {
        CompositeGlyph compositeGlyph = (CompositeGlyph)glyph;
        int instructionSize = compositeGlyph.instructionSize();
        int nonPaddedCompositeGlyphLength = compositeGlyph.dataLength() - compositeGlyph.padding();
        if (instructionSize > 0) {
            return nonPaddedCompositeGlyphLength - instructionSize * FontData.DataSize.BYTE.size() - FontData.DataSize.USHORT.size();
        }
        return nonPaddedCompositeGlyphLength;
    }
}

