/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.subsetter;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapFormat4;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CMapTableBuilder {
    private static final int MAX_FORMAT4_ENDCODE = 65535;
    private final Font.Builder fontBuilder;
    private final Map<Integer, Integer> mapping;

    public CMapTableBuilder(Font.Builder fontBuilder, Map<Integer, Integer> mapping) {
        this.fontBuilder = fontBuilder;
        this.mapping = mapping;
    }

    private List<CMap4Segment> getFormat4Segments() {
        Map.Entry entry;
        int unicode;
        ArrayList<CMap4Segment> result = new ArrayList<CMap4Segment>();
        TreeMap<Integer, Integer> sortedMap = new TreeMap<Integer, Integer>(this.mapping);
        if (!sortedMap.containsKey(65535)) {
            sortedMap.put(65535, 0);
        }
        CMap4Segment curSegment = null;
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext() && (unicode = ((Integer)(entry = iterator.next()).getKey()).intValue()) <= 65535) {
            int glyphId = (Integer)entry.getValue();
            if (curSegment == null || unicode != curSegment.getEndCode() + 1) {
                curSegment = new CMap4Segment(unicode, unicode);
                result.add(curSegment);
            } else {
                curSegment.setEndCode(unicode);
            }
            curSegment.getGlyphIds().add(glyphId);
        }
        return result;
    }

    private void buildCMapFormat4(CMapFormat4.Builder builder, List<CMap4Segment> segments) {
        ArrayList<CMapFormat4.Builder.Segment> segmentList = new ArrayList<CMapFormat4.Builder.Segment>();
        ArrayList<Integer> glyphIdArray = new ArrayList<Integer>();
        int idOffset = segments.size();
        for (int i = 0; i < segments.size(); ++i) {
            int idRangeOffset;
            CMap4Segment segment = segments.get(i);
            if (segment.isContiguous()) {
                idRangeOffset = 0;
            } else {
                idRangeOffset = (idOffset - i) * FontData.DataSize.USHORT.size();
                glyphIdArray.addAll(segment.getGlyphIds());
                idOffset += segment.getGlyphIds().size();
            }
            segmentList.add(new CMapFormat4.Builder.Segment(segment.getStartCode(), segment.getEndCode(), segment.idDelta(), idRangeOffset));
        }
        builder.setGlyphIdArray(glyphIdArray);
        builder.setSegments(segmentList);
    }

    public void build() {
        CMapTable.Builder cmapTableBuilder = (CMapTable.Builder)this.fontBuilder.newTableBuilder(Tag.cmap);
        CMapFormat4.Builder cmapBuilder = (CMapFormat4.Builder)cmapTableBuilder.newCMapBuilder(CMapTable.CMapId.WINDOWS_BMP, CMap.CMapFormat.Format4);
        this.buildCMapFormat4(cmapBuilder, this.getFormat4Segments());
    }

    private class CMap4Segment {
        private final int startCode;
        private int endCode;
        List<Integer> glyphIds;

        CMap4Segment(int startCode, int endCode) {
            this.startCode = startCode;
            this.endCode = endCode;
            this.glyphIds = new ArrayList<Integer>();
        }

        private boolean isContiguous() {
            int firstId = this.glyphIds.get(0);
            for (int index = 1; index < this.glyphIds.size(); ++index) {
                if (this.glyphIds.get(index) == firstId + index) continue;
                return false;
            }
            return true;
        }

        int idDelta() {
            return this.isContiguous() ? this.getGlyphIds().get(0) - this.getStartCode() : 0;
        }

        public int getStartCode() {
            return this.startCode;
        }

        public void setEndCode(int endCode) {
            this.endCode = endCode;
        }

        public int getEndCode() {
            return this.endCode;
        }

        public List<Integer> getGlyphIds() {
            return this.glyphIds;
        }
    }
}

