/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.sfnttool;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMapTable;
import com.google.typography.font.tools.conversion.eot.EOTWriter;
import com.google.typography.font.tools.conversion.woff.WoffWriter;
import com.google.typography.font.tools.sfnttool.GlyphCoverage;
import com.google.typography.font.tools.subsetter.HintStripper;
import com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SfntTool {
    public boolean strip = false;
    public String subsetString = null;
    public boolean woff = false;
    public boolean eot = false;
    public boolean mtx = false;

    public static void main(String[] args) throws IOException {
        SfntTool tool = new SfntTool();
        File fontFile = null;
        File outputFile = null;
        int nIters = 1;
        for (int i = 0; i < args.length; ++i) {
            String option = null;
            if (args[i].charAt(0) == '-') {
                option = args[i].substring(1);
            }
            if (option != null) {
                if (option.equals("help") || option.equals("?")) {
                    SfntTool.printUsage();
                    System.exit(0);
                    continue;
                }
                if (option.equals("b") || option.equals("bench")) {
                    nIters = 10000;
                    continue;
                }
                if (option.equals("h") || option.equals("hints")) {
                    tool.strip = true;
                    continue;
                }
                if (option.equals("s") || option.equals("string")) {
                    tool.subsetString = args[i + 1];
                    ++i;
                    continue;
                }
                if (option.equals("w") || option.equals("woff")) {
                    tool.woff = true;
                    continue;
                }
                if (option.equals("e") || option.equals("eot")) {
                    tool.eot = true;
                    continue;
                }
                if (option.equals("x") || option.equals("mtx")) {
                    tool.mtx = true;
                    continue;
                }
                SfntTool.printUsage();
                System.exit(1);
                continue;
            }
            if (fontFile == null) {
                fontFile = new File(args[i]);
                continue;
            }
            outputFile = new File(args[i]);
            break;
        }
        if (tool.woff && tool.eot) {
            System.out.println("WOFF and EOT options are mutually exclusive");
            System.exit(1);
        }
        if (fontFile != null && outputFile != null) {
            tool.subsetFontFile(fontFile, outputFile, nIters);
        } else {
            SfntTool.printUsage();
        }
    }

    private static final void printUsage() {
        System.out.println("Subset [-?|-h|-help] [-b] [-s string] fontfile outfile");
        System.out.println("Prototype font subsetter");
        System.out.println("\t-?,-help\tprint this help information");
        System.out.println("\t-s,-string\t String to subset");
        System.out.println("\t-b,-bench\t Benchmark (run 10000 iterations)");
        System.out.println("\t-h,-hints\t Strip hints");
        System.out.println("\t-w,-woff\t Output WOFF format");
        System.out.println("\t-e,-eot\t Output EOT format");
        System.out.println("\t-x,-mtx\t Enable Microtype Express compression for EOT format");
    }

    public void subsetFontFile(File fontFile, File outputFile, int nIters) throws IOException {
        this.subset(fontFile, (OutputStream)new FileOutputStream(outputFile), nIters);
    }

    public void subset(byte[] buf, OutputStream out, int nIters) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        this.subset(fontFactory.loadFonts(buf)[0], out, nIters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subset(File fontFile, OutputStream out, int nIters) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fontFile);
            byte[] fontBytes = new byte[(int)fontFile.length()];
            fis.read(fontBytes);
            Font[] fontArray = null;
            fontArray = fontFactory.loadFonts(fontBytes);
            Font font = fontArray[0];
            this.subset(font, out, nIters);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subset(Font font, OutputStream out, int nIters) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        ArrayList<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
        cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
        for (int i = 0; i < nIters; ++i) {
            Font newFont = font;
            if (this.subsetString != null) {
                RenumberingSubsetter subsetter = new RenumberingSubsetter(newFont, fontFactory);
                subsetter.setCMaps(cmapIds, 1);
                List<Integer> glyphs = GlyphCoverage.getGlyphCoverage(font, this.subsetString);
                subsetter.setGlyphs(glyphs);
                HashSet<Integer> removeTables = new HashSet<Integer>();
                removeTables.add(Tag.GDEF);
                removeTables.add(Tag.GPOS);
                removeTables.add(Tag.GSUB);
                removeTables.add(Tag.kern);
                removeTables.add(Tag.hdmx);
                removeTables.add(Tag.vmtx);
                removeTables.add(Tag.VDMX);
                removeTables.add(Tag.LTSH);
                removeTables.add(Tag.DSIG);
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
                subsetter.setRemoveTables(removeTables);
                newFont = subsetter.subset().build();
            }
            if (this.strip) {
                HintStripper hintStripper = new HintStripper(newFont, fontFactory);
                HashSet<Integer> removeTables = new HashSet<Integer>();
                removeTables.add(Tag.fpgm);
                removeTables.add(Tag.prep);
                removeTables.add(Tag.cvt);
                removeTables.add(Tag.hdmx);
                removeTables.add(Tag.VDMX);
                removeTables.add(Tag.LTSH);
                removeTables.add(Tag.DSIG);
                hintStripper.setRemoveTables(removeTables);
                newFont = hintStripper.subset().build();
            }
            try {
                if (this.woff) {
                    WritableFontData woffData = new WoffWriter().convert(newFont);
                    woffData.copyTo(out);
                    continue;
                }
                if (this.eot) {
                    WritableFontData eotData = new EOTWriter(this.mtx).convert(newFont);
                    eotData.copyTo(out);
                    continue;
                }
                fontFactory.serializeFont(newFont, out);
                continue;
            }
            finally {
                out.flush();
                out.close();
            }
        }
    }

    public static byte[] sub(File source, String strs, boolean strip) throws IOException {
        SfntTool tool = new SfntTool();
        tool.subsetString = strs;
        tool.strip = strip;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        tool.subset(source, (OutputStream)out, 1);
        return out.toByteArray();
    }

    public static byte[] sub(byte[] source, String strs, boolean strip) throws IOException {
        SfntTool tool = new SfntTool();
        tool.subsetString = strs;
        tool.strip = strip;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        tool.subset(source, (OutputStream)out, 1);
        return out.toByteArray();
    }
}

