/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.fontinfo;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.typography.font.sfntly.Font;
import com.google.typography.font.tools.fontinfo.CommandOptions;
import com.google.typography.font.tools.fontinfo.DataDisplayTable;
import com.google.typography.font.tools.fontinfo.FontInfo;
import com.google.typography.font.tools.fontinfo.FontUtils;
import java.io.IOException;

public class FontInfoMain {
    private static final String PROGRAM_NAME = "java -jar fontinfo.jar";

    public static void main(String[] args) {
        CommandOptions options = new CommandOptions();
        JCommander commander = null;
        try {
            commander = new JCommander((Object)options, args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            commander = new JCommander((Object)options, new String[]{"--help"});
        }
        if (options.help.booleanValue()) {
            commander.setProgramName(PROGRAM_NAME);
            commander.usage();
            return;
        }
        if (options.files.size() != 1) {
            System.out.println("Please specify a single font. Try 'java -jar fontinfo.jar --help' for more information.");
            return;
        }
        if (!(options.metrics.booleanValue() || options.general.booleanValue() || options.cmap.booleanValue() || options.chars.booleanValue() || options.blocks.booleanValue() || options.scripts.booleanValue() || options.glyphs.booleanValue() || options.all.booleanValue())) {
            options.general = true;
        }
        String fileName = options.files.get(0);
        Font[] fonts = null;
        try {
            fonts = FontUtils.getFonts(fileName);
        }
        catch (IOException e) {
            System.out.println("Unable to load font " + fileName);
            return;
        }
        for (int i = 0; i < fonts.length; ++i) {
            Font font = fonts[i];
            if (fonts.length > 1 && !options.csv.booleanValue()) {
                System.out.println("==== Information for font index " + i + " ====\n");
            }
            if (options.general.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println(String.format("sfnt version: %s", FontInfo.sfntVersion(font)));
                    System.out.println();
                    System.out.println("Font Tables");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listTables(font).csvStringArray(), fileName, i));
                    System.out.println();
                    System.out.println("Name Table Entries:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listNameEntries(font).csvStringArray(), fileName, i));
                    System.out.println();
                } else {
                    System.out.println(String.format("sfnt version: %s", FontInfo.sfntVersion(font)));
                    System.out.println();
                    System.out.println("Font Tables:");
                    FontInfo.listTables(font).prettyPrint();
                    System.out.println();
                    System.out.println("Name Table Entries:");
                    FontInfo.listNameEntries(font).prettyPrint();
                    System.out.println();
                }
            }
            if (options.metrics.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println("Font Metrics:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listFontMetrics(font).csvStringArray(), fileName, i));
                    System.out.println();
                } else {
                    System.out.println("Font Metrics:");
                    FontInfo.listFontMetrics(font).prettyPrint();
                    System.out.println();
                }
            }
            if (options.metrics.booleanValue() || options.glyphs.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println("Glyph Metrics:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listGlyphDimensionBounds(font).csvStringArray(), fileName, i));
                    System.out.println();
                } else {
                    System.out.println("Glyph Metrics:");
                    FontInfo.listGlyphDimensionBounds(font).prettyPrint();
                    System.out.println();
                }
            }
            if (options.cmap.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println("Cmaps in the font:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listCmaps(font).csvStringArray(), fileName, i));
                    System.out.println();
                } else {
                    System.out.println("Cmaps in the font:");
                    FontInfo.listCmaps(font).prettyPrint();
                    System.out.println();
                }
            }
            if (options.blocks.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println("Unicode block coverage:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listCharBlockCoverage(font).csvStringArray(), fileName, i));
                    System.out.println();
                } else {
                    System.out.println("Unicode block coverage:");
                    FontInfo.listCharBlockCoverage(font).prettyPrint();
                    System.out.println();
                }
            }
            if (options.scripts.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println("Unicode script coverage:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listScriptCoverage(font).csvStringArray(), fileName, i));
                    System.out.println();
                    if (options.detailed.booleanValue()) {
                        System.out.println("Uncovered code points in partially-covered scripts:");
                        System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listCharsNeededToCoverScript(font).csvStringArray(), fileName, i));
                        System.out.println();
                    }
                } else {
                    System.out.println("Unicode script coverage:");
                    FontInfo.listScriptCoverage(font).prettyPrint();
                    System.out.println();
                    if (options.detailed.booleanValue()) {
                        System.out.println("Uncovered code points in partially-covered scripts:");
                        FontInfo.listCharsNeededToCoverScript(font).prettyPrint();
                        System.out.println();
                    }
                }
            }
            if (options.chars.booleanValue() || options.all.booleanValue()) {
                if (options.csv.booleanValue()) {
                    System.out.println("Characters with valid glyphs:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listChars(font).csvStringArray(), fileName, i));
                    System.out.println();
                } else {
                    System.out.println("Characters with valid glyphs:");
                    FontInfo.listChars(font).prettyPrint();
                    System.out.println();
                    System.out.println(String.format("Total number of characters with valid glyphs: %d", FontInfo.numChars(font)));
                    System.out.println();
                }
            }
            if (!options.glyphs.booleanValue() && !options.all.booleanValue()) continue;
            DataDisplayTable unmappedGlyphs = FontInfo.listUnmappedGlyphs(font);
            if (options.csv.booleanValue()) {
                System.out.println(String.format("Total hinting size: %s", FontInfo.hintingSize(font)));
                System.out.println(String.format("Number of unmapped glyphs: %d / %d", unmappedGlyphs.getNumRows(), FontInfo.numGlyphs(font)));
                System.out.println();
                if (options.detailed.booleanValue()) {
                    System.out.println("Unmapped glyphs:");
                    System.out.println(FontInfoMain.prependDataAndBuildCsv(unmappedGlyphs.csvStringArray(), fileName, i));
                    System.out.println();
                }
                System.out.println("Subglyphs used by characters in the font:");
                System.out.println(FontInfoMain.prependDataAndBuildCsv(FontInfo.listSubglyphFrequency(font).csvStringArray(), fileName, i));
                System.out.println();
                continue;
            }
            System.out.println(String.format("Total hinting size: %s", FontInfo.hintingSize(font)));
            System.out.println(String.format("Number of unmapped glyphs: %d / %d", unmappedGlyphs.getNumRows(), FontInfo.numGlyphs(font)));
            System.out.println();
            if (options.detailed.booleanValue()) {
                System.out.println("Unmapped glyphs:");
                unmappedGlyphs.prettyPrint();
                System.out.println();
            }
            System.out.println("Subglyphs used by characters in the font:");
            FontInfo.listSubglyphFrequency(font).prettyPrint();
            System.out.println();
        }
    }

    private static String prependDataAndBuildCsv(String[] arr, String fontName, int fontIndex) {
        StringBuilder output = new StringBuilder("Font,font index,").append(arr[0]).append('\n');
        for (int i = 1; i < arr.length; ++i) {
            String row = arr[i];
            output.append(fontName).append(',').append("font index ").append(fontIndex).append(',').append(row).append('\n');
        }
        return output.toString();
    }
}

