/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype.component;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.opentype.component.Record;

final class TagOffsetRecord
implements Record {
    static final int RECORD_SIZE = 6;
    private static final int TAG_POS = 0;
    private static final int OFFSET_POS = 4;
    final int tag;
    final int offset;

    TagOffsetRecord(ReadableFontData data, int base) {
        this.tag = data.readULongAsInt(base + 0);
        this.offset = data.readUShort(base + 4);
    }

    TagOffsetRecord(int tag, int offset) {
        this.tag = tag;
        this.offset = offset;
    }

    @Override
    public int writeTo(WritableFontData newData, int base) {
        newData.writeULong(base + 0, this.tag);
        newData.writeUShort(base + 4, this.offset);
        return 6;
    }
}

