/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.opentype;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.opentype.LangSysTable;
import com.google.typography.font.sfntly.table.opentype.LanguageTag;
import com.google.typography.font.sfntly.table.opentype.component.TagOffsetsTable;
import com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;
import java.util.HashMap;
import java.util.Map;

public class ScriptTable
extends TagOffsetsTable<LangSysTable> {
    private static final int FIELD_COUNT = 1;
    private static final int DEFAULT_LANG_SYS_INDEX = 0;
    private static final int NO_DEFAULT_LANG_SYS = 0;

    ScriptTable(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
    }

    public LangSysTable defaultLangSysTable() {
        int defaultLangSysOffset = this.getField(0);
        if (defaultLangSysOffset == 0) {
            return null;
        }
        ReadableFontData newData = this.data.slice(defaultLangSysOffset);
        LangSysTable langSysTable = new LangSysTable(newData, this.dataIsCanonical);
        return langSysTable;
    }

    private LanguageTag langSysAt(int index) {
        return LanguageTag.fromTag(this.tagAt(index));
    }

    public Map<LanguageTag, LangSysTable> map() {
        HashMap<LanguageTag, LangSysTable> map = new HashMap<LanguageTag, LangSysTable>();
        LangSysTable defaultLangSys = this.defaultLangSysTable();
        if (defaultLangSys != null) {
            map.put(LanguageTag.DFLT, defaultLangSys);
        }
        for (int i = 0; i < this.count(); ++i) {
            LanguageTag lang;
            try {
                lang = this.langSysAt(i);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid LangSys tag found: " + e.getMessage());
                continue;
            }
            map.put(lang, (LangSysTable)this.subTableAt(i));
        }
        return map;
    }

    @Override
    protected LangSysTable readSubTable(ReadableFontData data, boolean dataIsCanonical) {
        return new LangSysTable(data, dataIsCanonical);
    }

    @Override
    public int fieldCount() {
        return 1;
    }

    static class Builder
    extends TagOffsetsTable.Builder<ScriptTable, LangSysTable> {
        private VisibleSubTable.Builder<LangSysTable> defLangSysBuilder;

        Builder() {
        }

        Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data, base, dataIsCanonical);
            int defLangSys = this.getField(0);
            if (defLangSys != 0) {
                this.defLangSysBuilder = new LangSysTable.Builder(data.slice(defLangSys), dataIsCanonical);
            }
        }

        @Override
        protected VisibleSubTable.Builder<LangSysTable> createSubTableBuilder(ReadableFontData data, int tag, boolean dataIsCanonical) {
            return new LangSysTable.Builder(data, dataIsCanonical);
        }

        @Override
        protected VisibleSubTable.Builder<LangSysTable> createSubTableBuilder() {
            return new LangSysTable.Builder();
        }

        @Override
        protected ScriptTable readTable(ReadableFontData data, int base, boolean dataIsCanonical) {
            return new ScriptTable(data, base, dataIsCanonical);
        }

        @Override
        public int subDataSizeToSerialize() {
            int size = super.subDataSizeToSerialize();
            if (this.defLangSysBuilder != null) {
                size += this.defLangSysBuilder.subDataSizeToSerialize();
            }
            return size;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            int byteCount = super.subSerialize(newData);
            if (this.defLangSysBuilder != null) {
                byteCount += this.defLangSysBuilder.subSerialize(newData.slice(byteCount));
            }
            return byteCount;
        }

        @Override
        public void subDataSet() {
            super.subDataSet();
            this.defLangSysBuilder = null;
        }

        @Override
        public int fieldCount() {
            return 1;
        }

        @Override
        protected void initFields() {
            this.setField(0, 0);
        }
    }
}

