/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class PostScriptTable
extends Table {
    private static final int VERSION_1 = 65536;
    private static final int VERSION_2 = 131072;
    private static final int NUM_STANDARD_NAMES = 258;
    private AtomicReference<List<String>> names = new AtomicReference();
    private static final String[] STANDARD_NAMES = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};

    private PostScriptTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int version() {
        return this.data.readFixed(Offset.version.offset);
    }

    public int italicAngle() {
        return this.data.readFixed(Offset.italicAngle.offset);
    }

    public int underlinePosition() {
        return this.data.readFWord(Offset.underlinePosition.offset);
    }

    public long isFixedPitchRaw() {
        return this.data.readULong(Offset.isFixedPitch.offset);
    }

    public boolean isFixedPitch() {
        return this.isFixedPitchRaw() != 0L;
    }

    public long minMemType42() {
        return this.data.readULong(Offset.minMemType42.offset);
    }

    public long maxMemType42() {
        return this.data.readULong(Offset.maxMemType42.offset);
    }

    public long minMemType1() {
        return this.data.readULong(Offset.minMemType1.offset);
    }

    public long maxMemType1() {
        return this.data.readULong(Offset.maxMemType1.offset);
    }

    public int numberOfGlyphs() {
        if (this.version() == 65536) {
            return 258;
        }
        if (this.version() == 131072) {
            return this.data.readUShort(Offset.numberOfGlyphs.offset);
        }
        return -1;
    }

    public String glyphName(int glyphNum) {
        int numberOfGlyphs = this.numberOfGlyphs();
        if (numberOfGlyphs > 0 && (glyphNum < 0 || glyphNum >= numberOfGlyphs)) {
            throw new IndexOutOfBoundsException();
        }
        int glyphNameIndex = 0;
        if (this.version() == 65536) {
            glyphNameIndex = glyphNum;
        } else if (this.version() == 131072) {
            glyphNameIndex = this.data.readUShort(Offset.glyphNameIndex.offset + 2 * glyphNum);
        } else {
            return null;
        }
        if (glyphNameIndex < 258) {
            return STANDARD_NAMES[glyphNameIndex];
        }
        return this.getNames().get(glyphNameIndex - 258);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getNames() {
        List<String> result = this.names.get();
        if (result == null && this.version() == 131072) {
            AtomicReference<List<String>> atomicReference = this.names;
            synchronized (atomicReference) {
                result = this.names.get();
                if (result == null) {
                    result = this.parse();
                    this.names.compareAndSet(null, result);
                }
            }
        }
        return result;
    }

    private List<String> parse() {
        ArrayList<String> names = null;
        if (this.version() == 131072) {
            int strLen;
            names = new ArrayList<String>();
            for (int index = Offset.glyphNameIndex.offset + 2 * this.numberOfGlyphs(); index < this.dataLength(); index += 1 + strLen) {
                strLen = this.data.readUByte(index);
                byte[] nameBytes = new byte[strLen];
                this.data.readBytes(index + 1, nameBytes, 0, strLen);
                try {
                    names.add(new String(nameBytes, "ISO-8859-1"));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        } else if (this.version() == 65536) {
            throw new IllegalStateException("Not meaningful to parse version 1 table");
        }
        return names;
    }

    public static class Builder
    extends TableBasedTableBuilder<PostScriptTable> {
        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected PostScriptTable subBuildTable(ReadableFontData data) {
            return new PostScriptTable(this.header(), data);
        }
    }

    private static enum Offset {
        version(0),
        italicAngle(4),
        underlinePosition(8),
        underlineThickness(10),
        isFixedPitch(12),
        minMemType42(16),
        maxMemType42(20),
        minMemType1(24),
        maxMemType1(28),
        numberOfGlyphs(32),
        glyphNameIndex(34);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

