/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTableContainerTable;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyph;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class EbdtTable
extends SubTableContainerTable {
    protected EbdtTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int version() {
        return this.data.readFixed(Offset.version.offset);
    }

    public BitmapGlyph glyph(int offset, int length, int format) {
        ReadableFontData glyphData = this.data.slice(offset, length);
        return BitmapGlyph.createGlyph(glyphData, format);
    }

    public static class Builder
    extends SubTableContainerTable.Builder<EbdtTable> {
        private final int version = 131072;
        private List<Map<Integer, BitmapGlyphInfo>> glyphLoca;
        private List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> glyphBuilders;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        public static Builder createBuilder(Header header, ReadableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        public void setLoca(List<Map<Integer, BitmapGlyphInfo>> locaList) {
            this.revert();
            this.glyphLoca = locaList;
        }

        public List<Map<Integer, BitmapGlyphInfo>> generateLocaList() {
            if (this.glyphBuilders == null) {
                if (this.glyphLoca == null) {
                    return new ArrayList<Map<Integer, BitmapGlyphInfo>>(0);
                }
                return this.glyphLoca;
            }
            ArrayList newLocaList = new ArrayList(this.glyphBuilders.size());
            int startOffset = Offset.headerLength.offset;
            for (Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> builderMap : this.glyphBuilders) {
                TreeMap<Integer, BitmapGlyphInfo> newLocaMap = new TreeMap<Integer, BitmapGlyphInfo>();
                int glyphOffset = 0;
                for (Map.Entry<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> glyphEntry : builderMap.entrySet()) {
                    BitmapGlyph.Builder<? extends BitmapGlyph> builder = glyphEntry.getValue();
                    int size = builder.subDataSizeToSerialize();
                    BitmapGlyphInfo info = new BitmapGlyphInfo(glyphEntry.getKey(), startOffset + glyphOffset, size, builder.format());
                    newLocaMap.put(glyphEntry.getKey(), info);
                    glyphOffset += size;
                }
                startOffset += glyphOffset;
                newLocaList.add(Collections.unmodifiableMap(newLocaMap));
            }
            return Collections.unmodifiableList(newLocaList);
        }

        public List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> glyphBuilders() {
            return this.getGlyphBuilders();
        }

        public void setGlyphBuilders(List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> glyphBuilders) {
            this.glyphBuilders = glyphBuilders;
            this.setModelChanged();
        }

        private List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> getGlyphBuilders() {
            if (this.glyphBuilders == null) {
                if (this.glyphLoca == null) {
                    throw new IllegalStateException("Loca values not set - unable to parse glyph data.");
                }
                this.glyphBuilders = Builder.initialize(this.internalReadData(), this.glyphLoca);
                this.setModelChanged();
            }
            return this.glyphBuilders;
        }

        public void revert() {
            this.glyphLoca = null;
            this.glyphBuilders = null;
            this.setModelChanged(false);
        }

        private static List<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> initialize(ReadableFontData data, List<Map<Integer, BitmapGlyphInfo>> locaList) {
            ArrayList<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>> glyphBuilderList = new ArrayList<Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>>>(locaList.size());
            if (data != null) {
                for (Map<Integer, BitmapGlyphInfo> locaMap : locaList) {
                    TreeMap<Integer, BitmapGlyph.Builder<BitmapGlyph>> glyphBuilderMap = new TreeMap<Integer, BitmapGlyph.Builder<BitmapGlyph>>();
                    for (Map.Entry<Integer, BitmapGlyphInfo> entry : locaMap.entrySet()) {
                        BitmapGlyphInfo info = entry.getValue();
                        BitmapGlyph.Builder<BitmapGlyph> glyphBuilder = BitmapGlyph.Builder.createGlyphBuilder(data.slice(info.offset(), info.length()), info.format());
                        glyphBuilderMap.put(entry.getKey(), glyphBuilder);
                    }
                    glyphBuilderList.add(glyphBuilderMap);
                }
            }
            return glyphBuilderList;
        }

        @Override
        protected EbdtTable subBuildTable(ReadableFontData data) {
            return new EbdtTable(this.header(), data);
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.glyphBuilders == null || this.glyphBuilders.size() == 0) {
                return 0;
            }
            boolean fixed = true;
            int size = Offset.headerLength.offset;
            for (Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> builderMap : this.glyphBuilders) {
                for (Map.Entry<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> glyphEntry : builderMap.entrySet()) {
                    BitmapGlyph.Builder<? extends BitmapGlyph> builder = glyphEntry.getValue();
                    int glyphSize = builder.subDataSizeToSerialize();
                    size += Math.abs(glyphSize);
                    fixed = glyphSize <= 0 ? false : fixed;
                }
            }
            return (fixed ? 1 : -1) * size;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.glyphBuilders != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int size = 0;
            size += newData.writeFixed(Offset.version.offset, this.version);
            for (Map<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> builderMap : this.glyphBuilders) {
                for (Map.Entry<Integer, BitmapGlyph.Builder<? extends BitmapGlyph>> glyphEntry : builderMap.entrySet()) {
                    BitmapGlyph.Builder<? extends BitmapGlyph> builder = glyphEntry.getValue();
                    size += builder.subSerialize(newData.slice(size));
                }
            }
            return size;
        }
    }

    protected static enum Offset {
        version(0),
        headerLength(FontData.DataSize.Fixed.size());

        protected final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

