/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.cache.dao;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.nutz.dao.DB;
import org.nutz.dao.DaoException;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.impl.sql.run.NutDaoExecutor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.cache.dao.CacheResult;
import org.nutz.plugins.cache.dao.XSqlAdapter;
import org.nutz.plugins.cache.dao.api.DaoCacheProvider;
import org.nutz.plugins.cache.dao.impl.adapter.XDb2SqlAdapter2;
import org.nutz.plugins.cache.dao.impl.adapter.XMySqlSqlAdapter;
import org.nutz.plugins.cache.dao.impl.adapter.XOracleSqlAdapter;
import org.nutz.plugins.cache.dao.impl.adapter.XPgSqlAdapter;
import org.nutz.plugins.cache.dao.impl.adapter.XSqlServerSqlAdapter;
import org.nutz.trans.Trans;

public class CachedNutDaoExecutor
extends NutDaoExecutor {
    protected DaoCacheProvider cacheProvider;
    protected boolean enableWhenTrans;
    protected String cacheClearMark = "dao-cache-clear";
    public static final String CacheSkipMark = "dao-cache-skip";
    protected Set<String> cachedTableNames = new HashSet<String>();
    protected Pattern cachedTableNamePatten;
    public static boolean DEBUG = false;
    protected boolean cache4Null = true;
    protected boolean enable = true;
    protected DB db = DB.MYSQL;
    private static final Log log = Logs.get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(Connection conn, DaoStatement st) {
        XSqlAdapter adapter;
        if (!this.enable || "true".equals(st.getContext().attr(CacheSkipMark))) {
            this._exec(conn, st);
            return;
        }
        String prepSql = st.toPreparedStatement();
        if (prepSql == null) {
            this._exec(conn, st);
            return;
        }
        SQLStatementParser parser = this.sqlParser(prepSql);
        List statementList = null;
        try {
            statementList = parser.parseStatementList();
        }
        catch (Exception e) {
            log.debug((Object)("parser SQL sql, skip cache detect!! SQL=" + prepSql));
            this._exec(conn, st);
            return;
        }
        if (statementList.size() != 1) {
            log.warn((Object)("more than one sql in one DaoStatement!! skip cache detect!! SQL=" + prepSql));
            this._exec(conn, st);
            return;
        }
        SQLStatement sqlStatement = (SQLStatement)statementList.get(0);
        if (sqlStatement == null) {
            log.warn((Object)("can't parse SQL !! skip cache detect!! SQL=" + prepSql));
            this._exec(conn, st);
            return;
        }
        switch (this.db) {
            case ORACLE: {
                adapter = new XOracleSqlAdapter();
                break;
            }
            case DB2: {
                adapter = new XDb2SqlAdapter2();
                break;
            }
            case PSQL: {
                adapter = new XPgSqlAdapter();
                break;
            }
            case SQLSERVER: {
                adapter = new XSqlServerSqlAdapter();
                break;
            }
            default: {
                adapter = new XMySqlSqlAdapter();
            }
        }
        sqlStatement.accept((SQLASTVisitor)adapter);
        List<String> tableNames = adapter.getTableNames();
        if (DEBUG) {
            log.debug((Object)("sql = " + prepSql + ", tables = " + tableNames));
        }
        if (sqlStatement instanceof SQLSelectStatement) {
            Object[][] params = st.getParamMatrix();
            if (Trans.isTransactionNone() || this.enableWhenTrans) {
                if (tableNames.size() == 1 && this.isCache4Table(tableNames.get(0)) && params.length <= 1) {
                    Object cachedValue;
                    String tableName = tableNames.get(0);
                    String key = this.genKey(st, prepSql, params);
                    if (DEBUG) {
                        log.debugf("KEY=%s SQL=%s", new Object[]{key, prepSql});
                    }
                    if ((cachedValue = this.getCacheProvider().get(this.genCacheName(tableName), key)) != null && !CacheResult.NOT_FOUNT.equals(cachedValue)) {
                        if (CacheResult.NULL.equals(cachedValue)) {
                            cachedValue = null;
                        }
                        if (DEBUG) {
                            log.debug((Object)("cache found key=" + key));
                        }
                        st.getContext().setResult(cachedValue);
                    } else {
                        if (DEBUG) {
                            log.debug((Object)("cache miss = " + prepSql));
                        }
                        this._exec(conn, st);
                        cachedValue = st.getContext().getResult();
                        if (cachedValue != null || this.cache4Null) {
                            this.getCacheProvider().put(this.genCacheName(tableName), key, cachedValue);
                        }
                    }
                    return;
                }
                if (DEBUG) {
                    log.debug((Object)("not good for cache >> " + prepSql));
                }
            }
            tableNames.clear();
        } else {
            Iterator<String> mark = st.getContext().attr(this.cacheClearMark);
            if (mark != null && ((Boolean)((Object)mark)).booleanValue()) {
                tableNames.clear();
            }
        }
        try {
            this._exec(conn, st);
        }
        finally {
            try {
                if (!tableNames.isEmpty()) {
                    for (String tableName : tableNames) {
                        if (DEBUG) {
                            log.debug((Object)("Clear Cache=" + tableName));
                        }
                        this.getCacheProvider().clear(this.genCacheName(tableName));
                    }
                }
            }
            catch (Throwable e) {
                log.warn((Object)("clear cache fail: " + tableNames), e);
            }
        }
    }

    protected String genKey(DaoStatement st, String prepareSql, Object[][] params) {
        StringBuilder sb = new StringBuilder();
        long hash = prepareSql.hashCode();
        Pager pager = st.getContext().getPager();
        if (pager != null) {
            sb.append("" + pager.getPageNumber() + ":" + pager.getPageSize() + ":");
        } else {
            sb.append("_:_:");
        }
        sb.append(prepareSql);
        if (params != null && params.length > 0 && params[0].length > 0) {
            for (Object param : params[0]) {
                String v = String.valueOf(param);
                sb.append(":").append(v);
                hash += (long)v.hashCode();
            }
        }
        return hash + ":" + sb.toString();
    }

    protected String genCacheName(String tableName) {
        return tableName;
    }

    protected SQLStatementParser sqlParser(String sql) {
        switch (this.db) {
            case MYSQL: 
            case SQLITE: {
                return new MySqlStatementParser(sql);
            }
            case ORACLE: {
                return new OracleStatementParser(sql);
            }
            case PSQL: {
                return new PGSQLStatementParser(sql);
            }
            case SQLSERVER: {
                return new SQLServerStatementParser(sql);
            }
            case DB2: {
                return new DB2StatementParser(sql);
            }
        }
        throw new DaoException("daocache not support at this database");
    }

    public void setCacheProvider(DaoCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setEnableWhenTrans(boolean enableWhenTrans) {
        this.enableWhenTrans = enableWhenTrans;
    }

    public void setCachedTableNames(Set<String> cachedTableNames) {
        this.cachedTableNames = cachedTableNames;
    }

    public void addCachedTableName(String name) {
        this.cachedTableNames.add(name);
    }

    public void setCachedTableNamePatten(Pattern cachedTableNamePatten) {
        this.cachedTableNamePatten = cachedTableNamePatten;
    }

    public void setCachedTableNamePatten(String cachedTableNamePatten) {
        this.cachedTableNamePatten = cachedTableNamePatten == null ? null : Pattern.compile(cachedTableNamePatten);
    }

    protected boolean isCache4Table(String tableName) {
        return this.cachedTableNames.contains(tableName) || this.cachedTableNamePatten != null && this.cachedTableNamePatten.matcher(tableName).find();
    }

    public DaoCacheProvider getCacheProvider() {
        if (this.cacheProvider == null) {
            throw new IllegalArgumentException("Need CacheProvider!!");
        }
        return this.cacheProvider;
    }

    public void setCache4Null(boolean cache4Null) {
        this.cache4Null = cache4Null;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
        if (!this.enable) {
            log.info((Object)"CachedNutDaoExecutor will disable.");
        }
    }

    public void setMeta(DatabaseMeta meta) {
        this.db = meta.getType();
    }

    protected void _exec(Connection conn, DaoStatement st) {
        super.exec(conn, st);
    }
}

