/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.aop.PermissionAnnotationHandler;
import org.apache.shiro.subject.Subject;
import org.nutz.integration.shiro.annotation.NutzRequiresPermissions;

public class NurtzPermissionAnnotationHandler
extends PermissionAnnotationHandler {
    public NurtzPermissionAnnotationHandler() {
        this.setAnnotationClass(NutzRequiresPermissions.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof NutzRequiresPermissions)) {
            return;
        }
        NutzRequiresPermissions rpAnnotation = (NutzRequiresPermissions)a;
        String[] perms = rpAnnotation.value();
        Subject subject = this.getSubject();
        if (perms.length == 1) {
            subject.checkPermission(perms[0]);
            return;
        }
        if (Logical.AND.equals((Object)rpAnnotation.logical())) {
            this.getSubject().checkPermissions(perms);
            return;
        }
        if (Logical.OR.equals((Object)rpAnnotation.logical())) {
            boolean hasAtLeastOnePermission = false;
            for (String permission : perms) {
                if (!this.getSubject().isPermitted(permission)) continue;
                hasAtLeastOnePermission = true;
            }
            if (!hasAtLeastOnePermission) {
                this.getSubject().checkPermission(perms[0]);
            }
        }
    }
}

